/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceupdate;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforceupdate.SalesforceUpdate;
import org.pentaho.di.trans.steps.salesforceupdate.SalesforceUpdateData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalesforceUpdateMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SalesforceUpdateMeta.class;
    private String targeturl;
    private String username;
    private String password;
    private String module;
    private String[] updateLookup;
    private Boolean[] useExternalId;
    private String[] updateStream;
    private String batchSize;
    private String timeout;
    private boolean useCompression;
    private boolean rollbackAllChangesOnError;

    public boolean isRollbackAllChangesOnError() {
        return this.rollbackAllChangesOnError;
    }

    public void setRollbackAllChangesOnError(boolean rollbackAllChangesOnError) {
        this.rollbackAllChangesOnError = rollbackAllChangesOnError;
    }

    public boolean isUsingCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public void setTimeOut(String TimeOut) {
        this.timeout = TimeOut;
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public Boolean[] getUseExternalId() {
        return this.useExternalId;
    }

    public void setUseExternalId(Boolean[] useExternalId) {
        this.useExternalId = useExternalId;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String user_name) {
        this.username = user_name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setBatchSize(String value) {
        this.batchSize = value;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public int getBatchSizeInt() {
        return Const.toInt((String)this.batchSize, (int)10);
    }

    public String getTargetURL() {
        return this.targeturl;
    }

    public void setTargetURL(String urlvalue) {
        this.targeturl = urlvalue;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        SalesforceUpdateMeta retval = (SalesforceUpdateMeta)super.clone();
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.updateLookup[i] = this.updateLookup[i];
            retval.updateStream[i] = this.updateStream[i];
            retval.useExternalId[i] = this.useExternalId[i];
        }
        return retval;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"targeturl", (String)this.targeturl));
        retval.append("    " + XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("    " + XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password), (boolean)false, (String[])new String[0]));
        retval.append("    " + XMLHandler.addTagValue((String)"module", (String)this.module));
        retval.append("    " + XMLHandler.addTagValue((String)"batchSize", (String)this.batchSize));
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.updateLookup[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.updateStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"useExternalId", (boolean)this.useExternalId[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("    " + XMLHandler.addTagValue((String)"useCompression", (boolean)this.useCompression));
        retval.append("    " + XMLHandler.addTagValue((String)"rollbackAllChangesOnError", (boolean)this.rollbackAllChangesOnError));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.targeturl = XMLHandler.getTagValue((Node)stepnode, (String)"targeturl");
            this.username = XMLHandler.getTagValue((Node)stepnode, (String)"username");
            this.password = XMLHandler.getTagValue((Node)stepnode, (String)"password");
            if (this.password != null && this.password.startsWith("Encrypted")) {
                this.password = Encr.decryptPassword((String)this.password.replace("Encrypted", "").replace(" ", ""));
            }
            this.module = XMLHandler.getTagValue((Node)stepnode, (String)"module");
            this.batchSize = XMLHandler.getTagValue((Node)stepnode, (String)"batchSize");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                String updateValue;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.updateLookup[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.updateStream[i] = XMLHandler.getTagValue((Node)fnode, (String)"field");
                if (this.updateStream[i] == null) {
                    this.updateStream[i] = this.updateLookup[i];
                }
                this.useExternalId[i] = (updateValue = XMLHandler.getTagValue((Node)fnode, (String)"useExternalId")) == null ? Boolean.FALSE : (updateValue.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE);
            }
            this.useCompression = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useCompression"));
            this.rollbackAllChangesOnError = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rollbackAllChangesOnError"));
            this.timeout = XMLHandler.getTagValue((Node)stepnode, (String)"timeout");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrvalues) {
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
        this.useExternalId = new Boolean[nrvalues];
    }

    @Override
    public void setDefault() {
        this.targeturl = "https://www.salesforce.com/services/Soap/u/21.0";
        this.password = "";
        this.module = "Account";
        this.batchSize = "10";
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.updateLookup[i] = "name" + (i + 1);
            this.updateStream[i] = "field" + (i + 1);
            this.useExternalId[i] = Boolean.FALSE;
        }
        this.useCompression = false;
        this.rollbackAllChangesOnError = false;
        this.timeout = "60000";
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.targeturl = rep.getStepAttributeString(id_step, "targeturl");
            this.module = rep.getStepAttributeString(id_step, "module");
            this.username = rep.getStepAttributeString(id_step, "username");
            this.password = rep.getStepAttributeString(id_step, "password");
            this.batchSize = rep.getStepAttributeString(id_step, "batchSize");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                this.updateLookup[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.updateStream[i] = rep.getStepAttributeString(id_step, i, "field_attribut");
                this.useExternalId[i] = rep.getStepAttributeBoolean(id_step, i, "field_useExternalId", false);
            }
            this.useCompression = rep.getStepAttributeBoolean(id_step, "useCompression");
            this.timeout = rep.getStepAttributeString(id_step, "timeout");
            this.rollbackAllChangesOnError = rep.getStepAttributeBoolean(id_step, "rollbackAllChangesOnError");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "targeturl", this.targeturl);
            rep.saveStepAttribute(id_transformation, id_step, "batchSize", this.batchSize);
            rep.saveStepAttribute(id_transformation, id_step, "module", this.module);
            rep.saveStepAttribute(id_transformation, id_step, "username", this.username);
            rep.saveStepAttribute(id_transformation, id_step, "password", this.password);
            for (int i = 0; i < this.updateLookup.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.updateLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_attribut", this.updateStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_useExternalId", this.useExternalId[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "useCompression", this.useCompression);
            rep.saveStepAttribute(id_transformation, id_step, "timeout", this.timeout);
            rep.saveStepAttribute(id_transformation, id_step, "rollbackAllChangesOnError", this.rollbackAllChangesOnError);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.targeturl) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoURL", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.URLOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.username) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoUsername", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.UsernameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.module) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoModule", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.ModuleOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = this.updateLookup.length == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.FieldsOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SalesforceUpdate(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SalesforceUpdateData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

