/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sapinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sapinput.SapInput;
import org.pentaho.di.trans.steps.sapinput.SapInputData;
import org.pentaho.di.trans.steps.sapinput.SapOutputField;
import org.pentaho.di.trans.steps.sapinput.SapParameter;
import org.pentaho.di.trans.steps.sapinput.SapType;
import org.pentaho.di.trans.steps.sapinput.sap.SAPFunction;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static final String XML_TAG_PARAMETERS = "parameters";
    private static final String XML_TAG_PARAMETER = "parameter";
    private static final String XML_TAG_FIELDS = "fields";
    private static final String XML_TAG_FIELD = "field";
    private static final String XML_TAG_FUNCTION = "function";
    private DatabaseMeta databaseMeta;
    private SAPFunction function;
    private List<SapParameter> parameters = new ArrayList<SapParameter>();
    private List<SapOutputField> outputFields = new ArrayList<SapOutputField>();

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public SAPFunction getFunction() {
        return this.function;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        SapInputMeta retval = (SapInputMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.function = null;
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        row.clear();
        for (SapOutputField field : this.outputFields) {
            ValueMeta valueMeta = new ValueMeta(field.getNewName(), field.getTargetType());
            valueMeta.setOrigin(origin);
            row.addValueMeta((ValueMetaInterface)valueMeta);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_FUNCTION)).append(Const.CR);
        if (this.function != null && !Const.isEmpty((String)this.function.getName())) {
            retval.append("    " + XMLHandler.addTagValue((String)"name", (String)this.function.getName()));
            retval.append("    " + XMLHandler.addTagValue((String)"description", (String)this.function.getDescription()));
            retval.append("    " + XMLHandler.addTagValue((String)"group", (String)this.function.getGroup()));
            retval.append("    " + XMLHandler.addTagValue((String)"application", (String)this.function.getApplication()));
            retval.append("    " + XMLHandler.addTagValue((String)"host", (String)this.function.getHost()));
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_FUNCTION)).append(Const.CR);
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        for (SapParameter sapParameter : this.parameters) {
            retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_PARAMETER));
            retval.append(XMLHandler.addTagValue((String)"field_name", (String)sapParameter.getFieldName(), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"sap_type", (String)sapParameter.getSapType().getCode(), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"table_name", (String)sapParameter.getTableName(), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"parameter_name", (String)sapParameter.getParameterName(), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"target_type", (String)ValueMeta.getTypeDesc((int)sapParameter.getTargetType()), (boolean)false, (String[])new String[0]));
            retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_PARAMETER)).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_FIELDS)).append(Const.CR);
        for (SapOutputField sapOutputField : this.outputFields) {
            retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_FIELD));
            retval.append(XMLHandler.addTagValue((String)"field_name", (String)sapOutputField.getSapFieldName(), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"sap_type", (String)sapOutputField.getSapType().getCode(), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"table_name", (String)sapOutputField.getTableName(), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"new_name", (String)sapOutputField.getNewName(), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"target_type", (String)ValueMeta.getTypeDesc((int)sapOutputField.getTargetType()), (boolean)false, (String[])new String[0]));
            retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_FIELD)).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_FIELDS)).append(Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"connection"));
            String functionName = XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_FUNCTION, (String)"name");
            String functionDescription = XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_FUNCTION, (String)"description");
            String functionGroup = XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_FUNCTION, (String)"group");
            String functionApplication = XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_FUNCTION, (String)"application");
            String functionHost = XMLHandler.getTagValue((Node)stepnode, (String)XML_TAG_FUNCTION, (String)"host");
            this.function = !Const.isEmpty((String)functionName) ? new SAPFunction(functionName, functionDescription, functionGroup, functionApplication, functionHost) : null;
            Node paramsNode = XMLHandler.getSubNode((Node)stepnode, (String)XML_TAG_PARAMETERS);
            int nrParameters = XMLHandler.countNodes((Node)paramsNode, (String)XML_TAG_PARAMETER);
            for (int i = 0; i < nrParameters; ++i) {
                Node paramNode = XMLHandler.getSubNodeByNr((Node)paramsNode, (String)XML_TAG_PARAMETER, (int)i);
                String fieldName = XMLHandler.getTagValue((Node)paramNode, (String)"field_name");
                SapType sapType = SapType.findTypeForCode(XMLHandler.getTagValue((Node)paramNode, (String)"sap_type"));
                String tableName = XMLHandler.getTagValue((Node)paramNode, (String)"table_name");
                int targetType = ValueMeta.getType((String)XMLHandler.getTagValue((Node)paramNode, (String)"target_type"));
                String parameterName = XMLHandler.getTagValue((Node)paramNode, (String)"parameter_name");
                this.parameters.add(new SapParameter(fieldName, sapType, tableName, parameterName, targetType));
            }
            Node fieldsNode = XMLHandler.getSubNode((Node)stepnode, (String)XML_TAG_FIELDS);
            int nrFields = XMLHandler.countNodes((Node)fieldsNode, (String)XML_TAG_FIELD);
            for (int i = 0; i < nrFields; ++i) {
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)fieldsNode, (String)XML_TAG_FIELD, (int)i);
                String sapFieldName = XMLHandler.getTagValue((Node)fieldNode, (String)"field_name");
                SapType sapType = SapType.findTypeForCode(XMLHandler.getTagValue((Node)fieldNode, (String)"sap_type"));
                String tableName = XMLHandler.getTagValue((Node)fieldNode, (String)"table_name");
                int targetType = ValueMeta.getType((String)XMLHandler.getTagValue((Node)fieldNode, (String)"target_type"));
                String newName = XMLHandler.getTagValue((Node)fieldNode, (String)"new_name");
                this.outputFields.add(new SapOutputField(sapFieldName, sapType, tableName, newName, targetType));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            if (this.function != null && !Const.isEmpty((String)this.function.getName())) {
                rep.saveStepAttribute(id_transformation, id_step, "function_name", this.function.getName());
                rep.saveStepAttribute(id_transformation, id_step, "function_description", this.function.getDescription());
                rep.saveStepAttribute(id_transformation, id_step, "function_group", this.function.getGroup());
                rep.saveStepAttribute(id_transformation, id_step, "function_application", this.function.getApplication());
                rep.saveStepAttribute(id_transformation, id_step, "function_host", this.function.getHost());
            }
            for (i = 0; i < this.parameters.size(); ++i) {
                SapParameter parameter = this.parameters.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_field_name", parameter.getFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_sap_type", parameter.getSapType() == null ? null : parameter.getSapType().getCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_table_name", parameter.getTableName());
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_name", parameter.getParameterName());
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_target_type", ValueMeta.getTypeDesc((int)parameter.getTargetType()));
            }
            for (i = 0; i < this.outputFields.size(); ++i) {
                SapOutputField field = this.outputFields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_sap_field_name", field.getSapFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_sap_type", field.getSapType() == null ? null : field.getSapType().getCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_table_name", field.getTableName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_target_type", ValueMeta.getTypeDesc((int)field.getTargetType()));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_new_name", field.getNewName());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            String functionName = rep.getStepAttributeString(id_step, "function_name");
            String functionDescription = rep.getStepAttributeString(id_step, "function_description");
            String functionGroup = rep.getStepAttributeString(id_step, "function_group");
            String functionApplication = rep.getStepAttributeString(id_step, "function_application");
            String functionHost = rep.getStepAttributeString(id_step, "function_host");
            this.function = !Const.isEmpty((String)functionName) ? new SAPFunction(functionName, functionDescription, functionGroup, functionApplication, functionHost) : null;
            int nrParameters = rep.countNrStepAttributes(id_step, "parameter_field_name");
            for (int i = 0; i < nrParameters; ++i) {
                String fieldName = rep.getStepAttributeString(id_step, i, "parameter_field_name");
                SapType sapType = SapType.findTypeForCode(rep.getStepAttributeString(id_step, i, "parameter_sap_type"));
                String tableName = rep.getStepAttributeString(id_step, i, "parameter_table_name");
                int targetType = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "parameter_target_type"));
                String parameterName = rep.getStepAttributeString(id_step, i, "parameter_name");
                this.parameters.add(new SapParameter(fieldName, sapType, tableName, parameterName, targetType));
            }
            int nrFields = rep.countNrStepAttributes(id_step, "field_sap_field_name");
            for (int i = 0; i < nrFields; ++i) {
                String sapFieldName = rep.getStepAttributeString(id_step, i, "field_sap_field_name");
                SapType sapType = SapType.findTypeForCode(rep.getStepAttributeString(id_step, i, "field_sap_type"));
                String tableName = rep.getStepAttributeString(id_step, i, "field_table_name");
                int targetType = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_target_type"));
                String newName = rep.getStepAttributeString(id_step, i, "field_new_name");
                this.outputFields.add(new SapOutputField(sapFieldName, sapType, tableName, newName, targetType));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, "Connection exists", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "Please select or create a connection to use", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.function != null) {
            cr = new CheckResult(1, "Function selected", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "Please select a function to use", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SapInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SapInputData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public List<SapParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<SapParameter> parameters) {
        this.parameters = parameters;
    }

    public List<SapOutputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<SapOutputField> outputFields) {
        this.outputFields = outputFields;
    }

    public void setFunction(SAPFunction function) {
        this.function = function;
    }
}

