/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.setvariable;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.setvariable.SetVariableData;
import org.pentaho.di.trans.steps.setvariable.SetVariableMeta;

public class SetVariable
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SetVariableMeta.class;
    private SetVariableMeta meta;
    private SetVariableData data;

    public SetVariable(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SetVariableMeta)smi;
        this.data = (SetVariableData)sdi;
        Object[] rowData = this.getRow();
        if (rowData == null) {
            if (this.first) {
                this.logBasic(BaseMessages.getString(PKG, (String)"SetVariable.Log.NoInputRowSetDefault", (String[])new String[0]));
                for (int i = 0; i < this.meta.getFieldName().length; ++i) {
                    if (Const.isEmpty((String)this.meta.getDefaultValue()[i])) continue;
                    this.setValue(rowData, i, true);
                }
            }
            this.logBasic("Finished after " + this.getLinesWritten() + " rows.");
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputMeta = this.getInputRowMeta().clone();
            this.logBasic(BaseMessages.getString(PKG, (String)"SetVariable.Log.SettingVar", (String[])new String[0]));
            for (int i = 0; i < this.meta.getFieldName().length; ++i) {
                this.setValue(rowData, i, false);
            }
            this.putRow(this.data.outputMeta, rowData);
            return true;
        }
        throw new KettleStepException(BaseMessages.getString(PKG, (String)"SetVariable.RuntimeError.MoreThanOneRowReceived.SETVARIABLE0007", (String[])new String[0]));
    }

    private void setValue(Object[] rowData, int i, boolean usedefault) throws KettleException {
        String varname;
        String value = null;
        if (usedefault) {
            value = this.environmentSubstitute(this.meta.getDefaultValue()[i]);
        } else {
            int index = this.data.outputMeta.indexOfValue(this.meta.getFieldName()[i]);
            if (index < 0) {
                throw new KettleException("Unable to find field [" + this.meta.getFieldName()[i] + "] in input row");
            }
            ValueMetaInterface valueMeta = this.data.outputMeta.getValueMeta(index);
            Object valueData = rowData[index];
            value = this.meta.isUsingFormatting() ? valueMeta.getString(valueData) : valueMeta.getCompatibleString(valueData);
        }
        if (value == null) {
            value = "";
        }
        if (Const.isEmpty((String)(varname = this.meta.getVariableName()[i]))) {
            if (Const.isEmpty((String)value)) {
                throw new KettleException("Variable name nor value was specified on line #" + (i + 1));
            }
            throw new KettleException("There was no variable name specified for value [" + value + "]");
        }
        Job parentJob = null;
        this.setVariable(varname, value);
        Trans trans = this.getTrans();
        trans.setVariable(varname, value);
        while (trans.getParentTrans() != null) {
            trans = trans.getParentTrans();
            trans.setVariable(varname, value);
        }
        switch (this.meta.getVariableType()[i]) {
            case 0: {
                System.setProperty(varname, value);
                for (parentJob = trans.getParentJob(); parentJob != null; parentJob = parentJob.getParentJob()) {
                    parentJob.setVariable(varname, value);
                }
                break;
            }
            case 3: {
                for (parentJob = trans.getParentJob(); parentJob != null; parentJob = parentJob.getParentJob()) {
                    parentJob.setVariable(varname, value);
                }
                break;
            }
            case 2: {
                parentJob = trans.getParentJob();
                if (parentJob == null) {
                    throw new KettleStepException("Can't set variable [" + varname + "] on parent job: the parent job is not available");
                }
                parentJob.setVariable(varname, value);
                Job gpJob = trans.getParentJob().getParentJob();
                if (gpJob != null) {
                    gpJob.setVariable(varname, value);
                    break;
                }
                throw new KettleStepException("Can't set variable [" + varname + "] on grand parent job: the grand parent job is not available");
            }
            case 1: {
                parentJob = trans.getParentJob();
                if (parentJob != null) {
                    parentJob.setVariable(varname, value);
                    break;
                }
                throw new KettleStepException("Can't set variable [" + varname + "] on parent job: the parent job is not available");
            }
        }
        this.logBasic(BaseMessages.getString(PKG, (String)"SetVariable.Log.SetVariableToValue", (String[])new String[]{this.meta.getVariableName()[i], value}));
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SetVariableMeta)smi;
        this.data = (SetVariableData)sdi;
        super.dispose(smi, sdi);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SetVariableMeta)smi;
        this.data = (SetVariableData)sdi;
        return super.init(smi, sdi);
    }
}

