/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sortedmerge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sortedmerge.RowSetRow;
import org.pentaho.di.trans.steps.sortedmerge.SortedMergeData;
import org.pentaho.di.trans.steps.sortedmerge.SortedMergeMeta;

public class SortedMerge
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SortedMergeMeta.class;
    private SortedMergeMeta meta;
    private SortedMergeData data;

    public SortedMerge(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized Object[] getRowSorted() throws KettleException {
        if (this.first) {
            this.first = false;
            this.openRemoteInputStepSocketsOnce();
            this.data.sortedBuffer = new ArrayList<RowSetRow>();
            this.data.rowMeta = null;
            for (int i = this.getInputRowSets().size() - 1; i >= 0 && !this.isStopped(); --i) {
                RowSet rowSet = this.getInputRowSets().get(i);
                Object[] row = this.getRowFrom(rowSet);
                if (row != null) {
                    this.data.sortedBuffer.add(new RowSetRow(rowSet, rowSet.getRowMeta(), row));
                    if (this.data.rowMeta == null) {
                        this.data.rowMeta = rowSet.getRowMeta().clone();
                    }
                    if (this.data.fieldIndices == null) {
                        this.data.fieldIndices = new int[this.meta.getFieldName().length];
                        for (int f = 0; f < this.data.fieldIndices.length; ++f) {
                            this.data.fieldIndices[f] = this.data.rowMeta.indexOfValue(this.meta.getFieldName()[f]);
                            if (this.data.fieldIndices[f] < 0) {
                                throw new KettleStepException("Unable to find fieldname [" + this.meta.getFieldName()[f] + "] in row : " + this.data.rowMeta);
                            }
                            this.data.rowMeta.getValueMeta(this.data.fieldIndices[f]).setSortedDescending(!this.meta.getAscending()[f]);
                        }
                    }
                }
                this.data.comparator = new Comparator<RowSetRow>(){

                    @Override
                    public int compare(RowSetRow o1, RowSetRow o2) {
                        try {
                            return o1.getRowMeta().compare(o1.getRowData(), o2.getRowData(), ((SortedMerge)SortedMerge.this).data.fieldIndices);
                        }
                        catch (KettleValueException e) {
                            return 0;
                        }
                    }
                };
                Collections.sort(this.data.sortedBuffer, this.data.comparator);
            }
        }
        if (this.data.sortedBuffer.isEmpty()) {
            return null;
        }
        RowSetRow smallestRow = this.data.sortedBuffer.get(0);
        this.data.sortedBuffer.remove(0);
        Object[] outputRowData = smallestRow.getRowData();
        Object[] extraRow = this.getRowFrom(smallestRow.getRowSet());
        if (extraRow != null) {
            RowSetRow add = new RowSetRow(smallestRow.getRowSet(), smallestRow.getRowSet().getRowMeta(), extraRow);
            int index = Collections.binarySearch(this.data.sortedBuffer, add, this.data.comparator);
            if (index < 0) {
                this.data.sortedBuffer.add(-index - 1, add);
            } else {
                this.data.sortedBuffer.add(index, add);
            }
        }
        if (this.getTrans().isSafeModeEnabled()) {
            this.safeModeChecking(smallestRow.getRowMeta());
        }
        return outputRowData;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SortedMergeMeta)smi;
        this.data = (SortedMergeData)sdi;
        Object[] row = this.getRowSorted();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(this.data.rowMeta, row);
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SortedMerge.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SortedMergeMeta)smi;
        this.data = (SortedMergeData)sdi;
        return super.init(smi, sdi);
    }
}

