/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stringcut;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.stringcut.StringCutData;
import org.pentaho.di.trans.steps.stringcut.StringCutMeta;

public class StringCut
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = StringCutMeta.class;
    private StringCutMeta meta;
    private StringCutData data;

    public StringCut(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private String CutString(String string, int cutFrom, int cutTo) {
        String rcode = string;
        if (!Const.isEmpty((String)rcode)) {
            int lenCode = rcode.length();
            if (cutFrom >= 0 && cutTo >= 0 && cutFrom > lenCode) {
                rcode = null;
            } else if (cutFrom >= 0 && cutTo >= 0 && cutTo < cutFrom) {
                rcode = null;
            } else if (cutFrom < 0 && cutTo < 0 && cutFrom < -lenCode) {
                rcode = null;
            } else if (cutFrom < 0 && cutTo < 0 && cutFrom < cutTo) {
                rcode = null;
            } else {
                if (cutTo > lenCode) {
                    cutTo = lenCode;
                }
                if (cutTo < 0 && cutFrom == 0 && -cutTo > lenCode) {
                    cutTo = -lenCode;
                }
                if (cutTo < 0 && cutFrom < 0 && -cutTo > lenCode) {
                    cutTo = -lenCode;
                }
                if (cutFrom >= 0 && cutTo > 0) {
                    rcode = rcode.substring(cutFrom, cutTo);
                } else if (cutFrom < 0 && cutTo < 0) {
                    rcode = rcode.substring(rcode.length() + cutTo, lenCode + cutFrom);
                } else if (cutFrom == 0 && cutTo < 0) {
                    int intFrom = rcode.length() + cutTo;
                    rcode = rcode.substring(intFrom, lenCode);
                }
            }
        }
        return rcode;
    }

    private synchronized Object[] getOneRow(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        Object[] RowData = new Object[this.data.outputRowMeta.size()];
        System.arraycopy(row, 0, RowData, 0, rowMeta.size());
        int length = this.meta.getFieldInStream().length;
        int j = 0;
        for (int i = 0; i < length; ++i) {
            String valueIn = this.getInputRowMeta().getString(row, this.data.inStreamNrs[i]);
            String value = this.CutString(valueIn, this.data.cutFrom[i], this.data.cutTo[i]);
            if (Const.isEmpty((String)this.data.outStreamNrs[i])) {
                RowData[this.data.inStreamNrs[i]] = value;
                continue;
            }
            RowData[this.data.inputFieldsNr + j] = value;
            ++j;
        }
        return RowData;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block10: {
            this.meta = (StringCutMeta)smi;
            this.data = (StringCutData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.data.inputFieldsNr = this.data.outputRowMeta.size();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.inStreamNrs = new int[this.meta.getFieldInStream().length];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.inStreamNrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldInStream()[i]);
                    if (this.data.inStreamNrs[i] < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"StringCut.Exception.FieldRequired", (String[])new String[]{this.meta.getFieldInStream()[i]}));
                    }
                    if (this.getInputRowMeta().getValueMeta(this.data.inStreamNrs[i]).getType() == 2) continue;
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"StringCut.Exception.FieldTypeNotString", (String[])new String[]{this.meta.getFieldInStream()[i]}));
                }
                this.data.outStreamNrs = new String[this.meta.getFieldInStream().length];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.outStreamNrs[i] = this.environmentSubstitute(this.meta.getFieldOutStream()[i]);
                }
                this.data.cutFrom = new int[this.meta.getFieldInStream().length];
                this.data.cutTo = new int[this.meta.getFieldInStream().length];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.cutFrom[i] = Const.isEmpty((String)this.meta.getCutFrom()[i]) ? 0 : Const.toInt((String)this.meta.getCutFrom()[i], (int)0);
                    this.data.cutTo[i] = Const.isEmpty((String)this.meta.getCutTo()[i]) ? 0 : Const.toInt((String)this.meta.getCutTo()[i], (int)0);
                }
            }
            try {
                Object[] output = this.getOneRow(this.getInputRowMeta(), r);
                this.putRow(this.data.outputRowMeta, output);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"StringCut.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"StringCut.Log.ErrorInStep", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block10;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "StringCut001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        boolean rCode = true;
        this.meta = (StringCutMeta)smi;
        this.data = (StringCutData)sdi;
        if (super.init(smi, sdi)) {
            return rCode;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (StringCutMeta)smi;
        this.data = (StringCutData)sdi;
        super.dispose(smi, sdi);
    }
}

