/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableoutput;

import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.exception.KettleDatabaseBatchException;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableoutput.TableOutputData;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = TableOutputMeta.class;
    private TableOutputMeta meta;
    private TableOutputData data;

    public TableOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (TableOutputMeta)smi;
        this.data = (TableOutputData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            if (!this.meta.specifyFields()) {
                this.data.insertRowMeta = this.getInputRowMeta().clone();
            } else {
                int i;
                this.data.insertRowMeta = new RowMeta();
                this.data.valuenrs = new int[this.meta.getFieldDatabase().length];
                for (i = 0; i < this.meta.getFieldDatabase().length; ++i) {
                    this.data.valuenrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                    if (this.data.valuenrs[i] >= 0) continue;
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"TableOutput.Exception.FieldRequired", (String[])new String[]{this.meta.getFieldStream()[i]}));
                }
                for (i = 0; i < this.meta.getFieldDatabase().length; ++i) {
                    ValueMetaInterface insValue = this.getInputRowMeta().searchValueMeta(this.meta.getFieldStream()[i]);
                    if (insValue == null) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"TableOutput.Exception.FailedToFindField", (String[])new String[]{this.meta.getFieldStream()[i]}));
                    }
                    ValueMetaInterface insertValue = insValue.clone();
                    insertValue.setName(this.meta.getFieldDatabase()[i]);
                    this.data.insertRowMeta.addValueMeta(insertValue);
                }
            }
        }
        try {
            Object[] outputRowData = this.writeToTable(this.getInputRowMeta(), r);
            if (outputRowData != null) {
                this.putRow(this.data.outputRowMeta, outputRowData);
                this.incrementLinesOutput();
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic("linenr " + this.getLinesRead());
            }
        }
        catch (KettleException e) {
            this.logError("Because of an error, this step can't continue: ", e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    protected Object[] writeToTable(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        Long generatedKey;
        boolean batchProblem;
        List exceptionsList;
        int[] updateCounts;
        boolean rowIsSafe;
        String errorMessage;
        boolean sendToErrorRow;
        Object[] outputRowData;
        block56: {
            Comparable<Date> partitioningValueData;
            Object[] insertRowData;
            if (r == null) {
                if (this.log.isDetailed()) {
                    this.logDetailed("Last line inserted: stop");
                }
                return null;
            }
            PreparedStatement insertStatement = null;
            outputRowData = r;
            String tableName = null;
            sendToErrorRow = false;
            errorMessage = null;
            rowIsSafe = false;
            updateCounts = null;
            exceptionsList = null;
            batchProblem = false;
            generatedKey = null;
            if (this.meta.isTableNameInField()) {
                if (this.data.indexOfTableNameField < 0) {
                    String realTablename = this.environmentSubstitute(this.meta.getTableNameField());
                    this.data.indexOfTableNameField = rowMeta.indexOfValue(realTablename);
                    if (this.data.indexOfTableNameField < 0) {
                        String message = "Unable to find table name field [" + realTablename + "] in input row";
                        this.logError(message);
                        throw new KettleStepException(message);
                    }
                    if (!this.meta.isTableNameInTable() && !this.meta.specifyFields()) {
                        this.data.insertRowMeta.removeValueMeta(this.data.indexOfTableNameField);
                    }
                }
                tableName = rowMeta.getString(r, this.data.indexOfTableNameField);
                insertRowData = !this.meta.isTableNameInTable() && !this.meta.specifyFields() ? RowDataUtil.removeItem((Object[])rowMeta.cloneRow(r), (int)this.data.indexOfTableNameField) : r;
            } else if (this.meta.isPartitioningEnabled() && (this.meta.isPartitioningDaily() || this.meta.isPartitioningMonthly()) && this.meta.getPartitioningField() != null && this.meta.getPartitioningField().length() > 0) {
                ValueMetaInterface partitioningValue;
                if (this.data.indexOfPartitioningField < 0) {
                    this.data.indexOfPartitioningField = rowMeta.indexOfValue(this.environmentSubstitute(this.meta.getPartitioningField()));
                    if (this.data.indexOfPartitioningField < 0) {
                        throw new KettleStepException("Unable to find field [" + this.meta.getPartitioningField() + "] in the input row!");
                    }
                    this.data.dateFormater = this.meta.isPartitioningDaily() ? new SimpleDateFormat("yyyyMMdd") : new SimpleDateFormat("yyyyMM");
                }
                if (!(partitioningValue = rowMeta.getValueMeta(this.data.indexOfPartitioningField)).isDate() || r[this.data.indexOfPartitioningField] == null) {
                    throw new KettleStepException("Sorry, the partitioning field needs to contain a data value and can't be empty!");
                }
                partitioningValueData = rowMeta.getDate(r, this.data.indexOfPartitioningField);
                tableName = this.environmentSubstitute(this.meta.getTableName()) + "_" + this.data.dateFormater.format((Date)partitioningValueData);
                insertRowData = r;
            } else {
                tableName = this.data.tableName;
                insertRowData = r;
            }
            if (this.meta.specifyFields()) {
                insertRowData = new Object[this.data.valuenrs.length];
                for (int idx = 0; idx < this.data.valuenrs.length; ++idx) {
                    insertRowData[idx] = r[this.data.valuenrs[idx]];
                }
            }
            if (Const.isEmpty((String)tableName)) {
                throw new KettleStepException("The tablename is not defined (empty)");
            }
            insertStatement = this.data.preparedStatements.get(tableName);
            if (insertStatement == null) {
                String sql = this.data.db.getInsertStatement(this.environmentSubstitute(this.meta.getSchemaName()), tableName, this.data.insertRowMeta);
                if (this.log.isDetailed()) {
                    this.logDetailed("Prepared statement : " + sql);
                }
                insertStatement = this.data.db.prepareSQL(sql, this.meta.isReturningGeneratedKeys());
                this.data.preparedStatements.put(tableName, insertStatement);
            }
            try {
                Integer commitCounter;
                if (this.data.useSafePoints) {
                    this.data.savepoint = this.data.db.setSavepoint();
                }
                this.data.db.setValues(this.data.insertRowMeta, insertRowData, insertStatement);
                this.data.db.insertRow(insertStatement, this.data.batchMode, false);
                if (this.log.isRowLevel()) {
                    this.logRowlevel("Written row: " + this.data.insertRowMeta.getString(insertRowData));
                }
                if ((commitCounter = this.data.commitCounterMap.get(tableName)) == null) {
                    commitCounter = 1;
                } else {
                    partitioningValueData = commitCounter;
                    Integer n = commitCounter = Integer.valueOf(commitCounter + 1);
                }
                this.data.commitCounterMap.put(tableName, (int)commitCounter);
                if (this.data.useSafePoints && this.data.releaseSavepoint) {
                    this.data.db.releaseSavepoint(this.data.savepoint);
                }
                if (this.data.commitSize > 0 && commitCounter % this.data.commitSize == 0) {
                    if (this.data.batchMode) {
                        try {
                            insertStatement.executeBatch();
                            this.data.db.commit();
                            insertStatement.clearBatch();
                        }
                        catch (BatchUpdateException ex) {
                            KettleDatabaseBatchException kdbe = new KettleDatabaseBatchException("Error updating batch", (Throwable)ex);
                            kdbe.setUpdateCounts(ex.getUpdateCounts());
                            ArrayList<BatchUpdateException> exceptions = new ArrayList<BatchUpdateException>();
                            SQLException nextException = ex;
                            do {
                                exceptions.add((BatchUpdateException)nextException);
                            } while ((nextException = nextException.getNextException()) != null);
                            kdbe.setExceptionsList(exceptions);
                            throw kdbe;
                        }
                        catch (SQLException ex) {
                            throw new KettleDatabaseException("Error inserting row", (Throwable)ex);
                        }
                        catch (Exception ex) {
                            throw new KettleDatabaseException("Unexpected error inserting row", (Throwable)ex);
                        }
                    } else {
                        this.data.db.commit();
                    }
                    this.data.commitCounterMap.put(tableName, 0);
                    rowIsSafe = true;
                } else {
                    rowIsSafe = false;
                }
                if (!this.meta.isReturningGeneratedKeys()) break block56;
                RowMetaAndData extraKeys = this.data.db.getGeneratedKeys(insertStatement);
                if (extraKeys.getRowMeta().size() > 0) {
                    generatedKey = extraKeys.getRowMeta().getInteger(extraKeys.getData(), 0);
                    break block56;
                }
                throw new KettleStepException("No generated keys while \"return generated keys\" is active!");
            }
            catch (KettleDatabaseBatchException be) {
                errorMessage = be.toString();
                batchProblem = true;
                sendToErrorRow = true;
                updateCounts = be.getUpdateCounts();
                exceptionsList = be.getExceptionsList();
                if (this.getStepMeta().isDoingErrorHandling()) {
                    this.data.db.clearBatch(insertStatement);
                    this.data.db.commit(true);
                }
                this.data.db.clearBatch(insertStatement);
                this.data.db.rollback();
                StringBuffer msg = new StringBuffer("Error batch inserting rows into table [" + tableName + "].");
                msg.append(Const.CR);
                msg.append("Errors encountered (first 10):").append(Const.CR);
                for (int x = 0; x < be.getExceptionsList().size() && x < 10; ++x) {
                    Exception exception = (Exception)be.getExceptionsList().get(x);
                    if (exception.getMessage() == null) continue;
                    msg.append(exception.getMessage()).append(Const.CR);
                }
                throw new KettleException(msg.toString(), (Throwable)be);
            }
            catch (KettleDatabaseException dbe) {
                if (this.getStepMeta().isDoingErrorHandling()) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel("Written row to error handling : " + this.getInputRowMeta().getString(r));
                    }
                    if (this.data.useSafePoints) {
                        this.data.db.rollback(this.data.savepoint);
                        if (this.data.releaseSavepoint) {
                            this.data.db.releaseSavepoint(this.data.savepoint);
                        }
                    }
                    sendToErrorRow = true;
                    errorMessage = dbe.toString();
                }
                if (this.meta.ignoreErrors()) {
                    if (this.data.warnings < 20) {
                        if (this.log.isBasic()) {
                            this.logBasic("WARNING: Couldn't insert row into table: " + rowMeta.getString(r) + Const.CR + dbe.getMessage());
                        }
                    } else if (this.data.warnings == 20 && this.log.isBasic()) {
                        this.logBasic("FINAL WARNING (no more then 20 displayed): Couldn't insert row into table: " + rowMeta.getString(r) + Const.CR + dbe.getMessage());
                    }
                    ++this.data.warnings;
                }
                this.setErrors(this.getErrors() + 1L);
                this.data.db.rollback();
                throw new KettleException("Error inserting row into table [" + tableName + "] with values: " + rowMeta.getString(r), (Throwable)dbe);
            }
        }
        if (generatedKey != null) {
            outputRowData = RowDataUtil.addValueData((Object[])outputRowData, (int)rowMeta.size(), generatedKey);
        }
        if (this.data.batchMode) {
            if (sendToErrorRow) {
                if (batchProblem) {
                    this.data.batchBuffer.add(outputRowData);
                    outputRowData = null;
                    this.processBatchException(errorMessage, updateCounts, exceptionsList);
                } else {
                    this.putError(rowMeta, r, 1L, errorMessage, null, "TOP001");
                    outputRowData = null;
                }
            } else {
                this.data.batchBuffer.add(outputRowData);
                outputRowData = null;
                if (rowIsSafe) {
                    for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                        Object[] row = this.data.batchBuffer.get(i);
                        this.putRow(this.data.outputRowMeta, row);
                        this.incrementLinesOutput();
                    }
                    this.data.batchBuffer.clear();
                }
            }
        } else if (sendToErrorRow) {
            this.putError(rowMeta, r, 1L, errorMessage, null, "TOP001");
            outputRowData = null;
        }
        return outputRowData;
    }

    private void processBatchException(String errorMessage, int[] updateCounts, List<Exception> exceptionsList) throws KettleException {
        if (updateCounts != null) {
            int errNr = 0;
            for (int i = 0; i < updateCounts.length; ++i) {
                Object[] row = this.data.batchBuffer.get(i);
                if (updateCounts[i] > 0) {
                    this.putRow(this.data.outputRowMeta, row);
                    this.incrementLinesOutput();
                    continue;
                }
                String exMessage = errorMessage;
                if (errNr < exceptionsList.size()) {
                    SQLException se = (SQLException)exceptionsList.get(errNr);
                    ++errNr;
                    exMessage = se.toString();
                }
                this.putError(this.data.outputRowMeta, row, 1L, exMessage, null, "TOP0002");
            }
        } else {
            for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                Object[] row = this.data.batchBuffer.get(i);
                this.putError(this.data.outputRowMeta, row, 1L, errorMessage, null, "TOP0003");
            }
        }
        this.data.batchBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TableOutputMeta)smi;
        this.data = (TableOutputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.commitSize = Integer.parseInt(this.environmentSubstitute(this.meta.getCommitSize()));
                this.data.databaseMeta = this.meta.getDatabaseMeta();
                DatabaseInterface dbInterface = this.data.databaseMeta.getDatabaseInterface();
                this.data.useSafePoints = this.data.databaseMeta.getDatabaseInterface().useSafePoints() && this.getStepMeta().isDoingErrorHandling();
                this.data.releaseSavepoint = dbInterface.releaseSavepoint();
                boolean bl = this.data.batchMode = this.meta.useBatchUpdate() && this.data.commitSize > 0 && !this.meta.isReturningGeneratedKeys() && !this.getTransMeta().isUsingUniqueConnections() && !this.data.useSafePoints;
                if (this.getStepMeta().isDoingErrorHandling() && !dbInterface.supportsErrorHandlingOnBatchUpdates()) {
                    this.log.logMinimal(BaseMessages.getString(PKG, (String)"TableOutput.Warning.ErrorHandlingIsNotFullySupportedWithBatchProcessing", (String[])new String[0]));
                }
                if (this.meta.getDatabaseMeta() == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TableOutput.Exception.DatabaseNeedsToBeSelected", (String[])new String[0]));
                }
                if (this.meta.getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"TableOutput.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                    return false;
                }
                this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.db.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isBasic()) {
                    this.logBasic("Connected to database [" + this.meta.getDatabaseMeta() + "] (commit=" + this.data.commitSize + ")");
                }
                if (this.data.commitSize == 0) {
                    this.data.commitSize = Integer.MAX_VALUE;
                }
                this.data.db.setCommit(this.data.commitSize);
                if (!this.meta.isPartitioningEnabled() && !this.meta.isTableNameInField()) {
                    this.data.tableName = this.environmentSubstitute(this.meta.getTableName());
                    if (this.meta.truncateTable() && (this.getCopy() == 0 && this.getUniqueStepNrAcrossSlaves() == 0 || !Const.isEmpty((String)this.getPartitionID()))) {
                        this.data.db.truncateTable(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
                    }
                }
                return true;
            }
            catch (KettleException e) {
                this.logError("An error occurred intialising this step: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TableOutputMeta)smi;
        this.data = (TableOutputData)sdi;
        if (this.data.db != null) {
            block23: {
                try {
                    for (String schemaTable : this.data.preparedStatements.keySet()) {
                        Integer batchCounter = this.data.commitCounterMap.get(schemaTable);
                        if (batchCounter == null) {
                            batchCounter = 0;
                        }
                        PreparedStatement insertStatement = this.data.preparedStatements.get(schemaTable);
                        this.data.db.emptyAndCommit(insertStatement, this.data.batchMode, batchCounter.intValue());
                    }
                    for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                        Object[] row = this.data.batchBuffer.get(i);
                        this.putRow(this.data.outputRowMeta, row);
                        this.incrementLinesOutput();
                    }
                    this.data.batchBuffer.clear();
                    Object var8_11 = null;
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    this.setOutputDone();
                    if (this.getErrors() > 0L) {
                        try {
                            this.data.db.rollback();
                        }
                        catch (KettleDatabaseException e) {
                            this.logError("Unexpected error rolling back the database connection.", e);
                        }
                    }
                    this.data.db.disconnect();
                    throw throwable;
                }
                this.setOutputDone();
                if (this.getErrors() > 0L) {
                    try {
                        this.data.db.rollback();
                    }
                    catch (KettleDatabaseException e) {
                        this.logError("Unexpected error rolling back the database connection.", e);
                    }
                }
                this.data.db.disconnect();
                {
                    break block23;
                    catch (KettleDatabaseBatchException be) {
                        if (this.getStepMeta().isDoingErrorHandling()) {
                            try {
                                this.processBatchException(be.toString(), be.getUpdateCounts(), be.getExceptionsList());
                            }
                            catch (KettleException e) {
                                this.logError("Unexpected error processing batch error", e);
                                this.setErrors(1L);
                                this.stopAll();
                            }
                        } else {
                            this.logError("Unexpected batch update error committing the database connection.", be);
                            this.setErrors(1L);
                            this.stopAll();
                        }
                        Object var8_12 = null;
                        this.setOutputDone();
                        if (this.getErrors() > 0L) {
                            try {
                                this.data.db.rollback();
                            }
                            catch (KettleDatabaseException e) {
                                this.logError("Unexpected error rolling back the database connection.", e);
                            }
                        }
                        this.data.db.disconnect();
                        break block23;
                    }
                    catch (Exception dbe) {
                        this.logError("Unexpected error committing the database connection.", dbe);
                        this.logError(Const.getStackTracker((Throwable)dbe));
                        this.setErrors(1L);
                        this.stopAll();
                        Object var8_13 = null;
                        this.setOutputDone();
                        if (this.getErrors() > 0L) {
                            try {
                                this.data.db.rollback();
                            }
                            catch (KettleDatabaseException e) {
                                this.logError("Unexpected error rolling back the database connection.", e);
                            }
                        }
                        this.data.db.disconnect();
                    }
                }
            }
            super.dispose(smi, sdi);
        }
    }

    protected TableOutputMeta getMeta() {
        return this.meta;
    }

    protected TableOutputData getData() {
        return this.data;
    }
}

