/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.uniquerows;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.uniquerows.UniqueRows;
import org.pentaho.di.trans.steps.uniquerows.UniqueRowsData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = UniqueRowsMeta.class;
    private boolean countRows;
    private String countField;
    private String[] compareFields;
    private boolean[] caseInsensitive;
    private boolean rejectDuplicateRow;
    private String errorDescription;

    public boolean isCountRows() {
        return this.countRows;
    }

    public void setCountRows(boolean countRows) {
        this.countRows = countRows;
    }

    public String getCountField() {
        return this.countField;
    }

    public void setCountField(String countField) {
        this.countField = countField;
    }

    public void setCompareFields(String[] compareField) {
        this.compareFields = compareField;
    }

    public String[] getCompareFields() {
        return this.compareFields;
    }

    public void setRejectDuplicateRow(boolean rejectDuplicateRow) {
        this.rejectDuplicateRow = rejectDuplicateRow;
    }

    public boolean isRejectDuplicateRow() {
        return this.rejectDuplicateRow;
    }

    public void allocate(int nrfields) {
        this.compareFields = new String[nrfields];
        this.caseInsensitive = new boolean[nrfields];
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        UniqueRowsMeta retval = (UniqueRowsMeta)super.clone();
        int nrfields = this.compareFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.getCompareFields()[i] = this.compareFields[i];
            retval.getCaseInsensitive()[i] = this.caseInsensitive[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.countRows = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"count_rows"));
            this.countField = XMLHandler.getTagValue((Node)stepnode, (String)"count_field");
            this.rejectDuplicateRow = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"reject_duplicate_row"));
            this.errorDescription = XMLHandler.getTagValue((Node)stepnode, (String)"error_description");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.compareFields[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.caseInsensitive[i] = !"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"case_insensitive"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"UniqueRowsMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.countRows = false;
        this.countField = "";
        this.rejectDuplicateRow = false;
        this.errorDescription = null;
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.compareFields[i] = "field" + i;
            this.caseInsensitive[i] = true;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        for (int i = 0; i < this.compareFields.length; ++i) {
            int idx = row.indexOfValue(this.compareFields[i]);
            if (idx < 0) continue;
            row.getValueMeta(idx).setCaseInsensitive(this.caseInsensitive[i]);
        }
        if (this.countRows) {
            ValueMeta v = new ValueMeta(this.countField, 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("      " + XMLHandler.addTagValue((String)"count_rows", (boolean)this.countRows));
        retval.append("      " + XMLHandler.addTagValue((String)"count_field", (String)this.countField));
        retval.append("      " + XMLHandler.addTagValue((String)"reject_duplicate_row", (boolean)this.rejectDuplicateRow));
        retval.append("      " + XMLHandler.addTagValue((String)"error_description", (String)this.errorDescription));
        retval.append("    <fields>");
        for (int i = 0; i < this.compareFields.length; ++i) {
            retval.append("      <field>");
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.compareFields[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"case_insensitive", (boolean)this.caseInsensitive[i]));
            retval.append("        </field>");
        }
        retval.append("      </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.countRows = rep.getStepAttributeBoolean(id_step, "count_rows");
            this.countField = rep.getStepAttributeString(id_step, "count_fields");
            this.rejectDuplicateRow = rep.getStepAttributeBoolean(id_step, "reject_duplicate_row");
            this.errorDescription = rep.getStepAttributeString(id_step, "error_description");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.compareFields[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.caseInsensitive[i] = rep.getStepAttributeBoolean(id_step, i, "case_insensitive", true);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UniqueRowsMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "count_rows", this.countRows);
            rep.saveStepAttribute(id_transformation, id_step, "count_fields", this.countField);
            rep.saveStepAttribute(id_transformation, id_step, "reject_duplicate_row", this.rejectDuplicateRow);
            rep.saveStepAttribute(id_transformation, id_step, "error_description", this.errorDescription);
            for (int i = 0; i < this.compareFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.compareFields[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "case_insensitive", this.caseInsensitive[i]);
            }
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UniqueRowsMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UniqueRowsMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UniqueRowsMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new UniqueRows(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new UniqueRowsData();
    }

    public boolean[] getCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean[] caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public boolean supportsErrorHandling() {
        return this.isRejectDuplicateRow();
    }
}

