/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.valuemapper;

import java.util.Hashtable;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.valuemapper.ValueMapperData;
import org.pentaho.di.trans.steps.valuemapper.ValueMapperMeta;

public class ValueMapper
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ValueMapperMeta.class;
    private ValueMapperMeta meta;
    private ValueMapperData data;
    private boolean nonMatchActivated = false;

    public ValueMapper(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ValueMapperMeta)smi;
        this.data = (ValueMapperData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.previousMeta = this.getInputRowMeta().clone();
            this.data.outputMeta = this.data.previousMeta.clone();
            this.meta.getFields(this.data.outputMeta, this.getStepname(), null, null, this);
            this.data.keynr = this.data.previousMeta.indexOfValue(this.meta.getFieldToUse());
            if (this.data.keynr < 0) {
                String message = BaseMessages.getString(PKG, (String)"ValueMapper.RuntimeError.FieldToUseNotFound.VALUEMAPPER0001", (String[])new String[]{this.meta.getFieldToUse(), Const.CR, this.getInputRowMeta().getString(r)});
                this.logError(message);
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            for (int i = 0; i < this.meta.getSourceValue().length; ++i) {
                if (!Const.isEmpty((String)this.meta.getSourceValue()[i])) continue;
                if (this.data.emptyFieldIndex < 0) {
                    this.data.emptyFieldIndex = i;
                    continue;
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"ValueMapper.RuntimeError.OnlyOneEmptyMappingAllowed.VALUEMAPPER0004", (String[])new String[0]));
            }
            this.data.sourceValueMeta = this.getInputRowMeta().getValueMeta(this.data.keynr);
            this.data.outputValueMeta = Const.isEmpty((String)this.meta.getTargetField()) ? this.data.outputMeta.getValueMeta(this.data.keynr) : this.data.outputMeta.searchValueMeta(this.meta.getTargetField());
        }
        Object sourceData = r[this.data.keynr];
        String source = this.data.sourceValueMeta.getCompatibleString(sourceData);
        String target = null;
        if (this.data.emptyFieldIndex >= 0 && (r[this.data.keynr] == null || Const.isEmpty((String)source))) {
            target = this.meta.getTargetValue()[this.data.emptyFieldIndex];
        } else if (!Const.isEmpty((String)source)) {
            target = this.data.hashtable.get(source);
            if (this.nonMatchActivated && target == null) {
                target = this.meta.getNonMatchDefault();
            }
        }
        if (!Const.isEmpty((String)this.meta.getTargetField())) {
            r = RowDataUtil.resizeArray((Object[])r, (int)this.data.outputMeta.size());
            r[this.data.outputMeta.size() - 1] = !Const.isEmpty((String)target) ? target : null;
        } else if (target != null) {
            r[this.data.keynr] = target.length() > 0 ? (this.data.sourceValueMeta.isString() ? target : this.data.outputValueMeta.convertData(this.data.stringMeta, (Object)target)) : null;
        } else if (this.data.sourceValueMeta.isStorageBinaryString()) {
            Object normal;
            r[this.data.keynr] = normal = this.data.sourceValueMeta.convertToNormalStorageType(r[this.data.keynr]);
        }
        this.putRow(this.data.outputMeta, r);
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ValueMapperMeta)smi;
        this.data = (ValueMapperData)sdi;
        super.dispose(smi, sdi);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ValueMapperMeta)smi;
        this.data = (ValueMapperData)sdi;
        if (super.init(smi, sdi)) {
            this.data.hashtable = new Hashtable();
            this.data.emptyFieldIndex = -1;
            if (!Const.isEmpty((String)this.meta.getNonMatchDefault())) {
                this.nonMatchActivated = true;
            }
            for (int i = 0; i < this.meta.getSourceValue().length; ++i) {
                String src = this.meta.getSourceValue()[i];
                String tgt = this.meta.getTargetValue()[i];
                if (!Const.isEmpty((String)src) && !Const.isEmpty((String)tgt)) {
                    this.data.hashtable.put(src, tgt);
                    continue;
                }
                if (!Const.isEmpty((String)tgt)) continue;
                this.data.hashtable.put(src, "");
            }
            return true;
        }
        return false;
    }
}

