/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xbaseinput;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;

public class XBase {
    private LogChannelInterface log;
    private String dbfFile;
    private DBFReader reader;
    private InputStream inputstream;
    private boolean error;
    private byte[] datatype;
    private static final byte FIELD_TYPE_I = 73;

    public XBase(LogChannelInterface log, String file_dbf) {
        this.log = log;
        this.dbfFile = file_dbf;
        this.error = false;
        this.reader = null;
        this.inputstream = null;
    }

    public XBase(LogChannelInterface log, InputStream inputStream) {
        this.log = log;
        this.dbfFile = null;
        this.error = false;
        this.reader = null;
        this.inputstream = inputStream;
    }

    public void open() throws KettleException {
        try {
            if (this.inputstream == null) {
                this.inputstream = new FileInputStream(this.dbfFile);
            }
            this.reader = new DBFReader(this.inputstream);
        }
        catch (DBFException e) {
            throw new KettleException("Error opening DBF metadata", (Throwable)e);
        }
        catch (IOException e) {
            throw new KettleException("Error reading DBF file", (Throwable)e);
        }
    }

    public RowMetaInterface getFields() throws KettleException {
        String debug = "get fields from XBase file";
        RowMeta row = new RowMeta();
        try {
            debug = "allocate data types";
            this.datatype = new byte[this.reader.getFieldCount()];
            for (int i = 0; i < this.reader.getFieldCount(); ++i) {
                if (this.log.isDebug()) {
                    debug = "get field #" + i;
                }
                DBFField field = this.reader.getField(i);
                ValueMeta value = null;
                this.datatype[i] = field.getDataType();
                switch (this.datatype[i]) {
                    case 77: {
                        debug = "memo field";
                        System.out.println("Field #" + i + " is a memo-field! (" + field.getName() + ")");
                    }
                    case 67: {
                        debug = "character field";
                        value = new ValueMeta(field.getName(), 2);
                        value.setLength(field.getFieldLength());
                        break;
                    }
                    case 70: 
                    case 73: 
                    case 78: {
                        debug = "Number field";
                        value = new ValueMeta(field.getName(), 1);
                        value.setLength(field.getFieldLength(), field.getDecimalCount());
                        break;
                    }
                    case 76: {
                        debug = "Logical field";
                        value = new ValueMeta(field.getName(), 4);
                        value.setLength(-1, -1);
                        break;
                    }
                    case 68: {
                        debug = "Date field";
                        value = new ValueMeta(field.getName(), 3);
                        value.setLength(-1, -1);
                        break;
                    }
                    default: {
                        System.out.println("Unknown Datatype" + this.datatype[i]);
                    }
                }
                if (value == null) continue;
                row.addValueMeta((ValueMetaInterface)value);
            }
        }
        catch (Exception e) {
            throw new KettleException("Error reading DBF metadata (in part " + debug + ")", (Throwable)e);
        }
        return row;
    }

    public Object[] getRow(RowMetaInterface fields) throws KettleException {
        return this.getRow(RowDataUtil.allocateRowData((int)fields.size()));
    }

    public Object[] getRow(Object[] r) throws KettleException {
        try {
            Object[] rowobj = this.reader.nextRecord();
            if (rowobj == null) {
                return null;
            }
            block18: for (int i = 0; i < this.reader.getFieldCount(); ++i) {
                switch (this.datatype[i]) {
                    case 77: {
                        if (rowobj[i] == null) continue block18;
                        r[i] = (String)rowobj[i];
                        continue block18;
                    }
                    case 67: {
                        r[i] = Const.rtrim((String)((String)rowobj[i]));
                        continue block18;
                    }
                    case 73: {
                        try {
                            if (rowobj[i] == null) continue block18;
                            r[i] = ((Integer)rowobj[i]).doubleValue();
                            continue block18;
                        }
                        catch (NumberFormatException e) {
                            throw new KettleException("Error parsing field #" + (i + 1) + " : " + this.reader.getField(i).getName(), (Throwable)e);
                        }
                    }
                    case 78: {
                        try {
                            if (rowobj[i] == null) continue block18;
                            r[i] = (Double)rowobj[i];
                            continue block18;
                        }
                        catch (NumberFormatException e) {
                            throw new KettleException("Error parsing field #" + (i + 1) + " : " + this.reader.getField(i).getName(), (Throwable)e);
                        }
                    }
                    case 70: {
                        try {
                            if (rowobj[i] == null) continue block18;
                            r[i] = new Double(((Float)rowobj[i]).floatValue());
                            continue block18;
                        }
                        catch (NumberFormatException e) {
                            throw new KettleException("Error parsing field #" + (i + 1) + " : " + this.reader.getField(i).getName(), (Throwable)e);
                        }
                    }
                    case 76: {
                        r[i] = (Boolean)rowobj[i];
                        continue block18;
                    }
                    case 68: {
                        r[i] = (Date)rowobj[i];
                        continue block18;
                    }
                }
            }
        }
        catch (DBFException e) {
            this.log.logError("Unable to read row : " + e.toString());
            this.error = true;
            throw new KettleException("Unable to read row from XBase file", (Throwable)e);
        }
        catch (Exception e) {
            this.log.logError("Unexpected error while reading row: " + e.toString());
            this.error = true;
            throw new KettleException("Unable to read row from XBase file", (Throwable)e);
        }
        return r;
    }

    public boolean close() {
        boolean retval = false;
        try {
            if (this.inputstream != null) {
                this.inputstream.close();
            }
            retval = true;
        }
        catch (IOException e) {
            this.log.logError("Couldn't close file [" + this.dbfFile + "] : " + e.toString());
            this.error = true;
        }
        return retval;
    }

    public boolean hasError() {
        return this.error;
    }

    public String toString() {
        if (this.dbfFile != null) {
            return this.dbfFile;
        }
        return this.getClass().getName();
    }

    public String getDbfFile() {
        return this.dbfFile;
    }

    public void setDbfFile(String dbfFile) {
        this.dbfFile = dbfFile;
    }

    public DBFReader getReader() {
        return this.reader;
    }
}

