/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.yamlinput;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.yaml.snakeyaml.Yaml;

public class YamlReader {
    private static final String DEFAULT_LIST_VALUE_NAME = "Value";
    private String filename = null;
    private String string = null;
    private FileObject file = null;
    private List<Object> documents = new ArrayList<Object>();
    private Object document;
    private Iterator<Object> documenti;
    private Object dataList = null;
    private Iterator<Object> dataListi;
    private boolean useMap = true;
    private Yaml yaml = new Yaml();

    public void loadFile(FileObject file) throws Exception {
        this.file = file;
        this.filename = KettleVFS.getFilename((FileObject)file);
        this.loadFile(this.filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadFile(String filename) throws Exception {
        this.filename = filename;
        this.file = KettleVFS.getFileObject((String)filename);
        InputStream is = null;
        try {
            is = KettleVFS.getInputStream((FileObject)this.getFile());
            for (Object data : this.getYaml().loadAll(is)) {
                this.documents.add(data);
                this.useMap = data instanceof Map;
            }
            this.documenti = this.documents.iterator();
            Object var6_5 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
    }

    private Yaml getYaml() {
        return this.yaml;
    }

    public void loadString(String string) throws Exception {
        this.string = string;
        for (Object data : this.getYaml().loadAll(this.getStringValue())) {
            this.documents.add(data);
            this.useMap = data instanceof Map;
        }
        this.documenti = this.documents.iterator();
    }

    public boolean isMapUsed() {
        return this.useMap;
    }

    public Object[] getRow(RowMetaInterface rowMeta) throws KettleException {
        Object[] retval = null;
        if (this.getDocument() != null) {
            if (this.isMapUsed()) {
                Map map = (Map)this.getDocument();
                retval = new Object[rowMeta.size()];
                for (int i = 0; i < rowMeta.size(); ++i) {
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
                    String o = null;
                    o = Const.isEmpty((String)valueMeta.getName()) ? this.getDocument().toString() : map.get(valueMeta.getName());
                    retval[i] = this.getValue(o, valueMeta);
                }
                this.finishDocument();
            } else if (this.dataList != null) {
                List list = (List)this.getDocument();
                if (list.size() == 1) {
                    Iterator it = list.iterator();
                    Object value = it.next();
                    Map map = (Map)value;
                    retval = new Object[rowMeta.size()];
                    for (int i = 0; i < rowMeta.size(); ++i) {
                        ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
                        String o = null;
                        o = Const.isEmpty((String)valueMeta.getName()) ? this.getDocument().toString() : map.get(valueMeta.getName());
                        retval[i] = this.getValue(o, valueMeta);
                    }
                } else {
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(0);
                    retval = new Object[]{this.getValue(this.dataList, valueMeta)};
                }
                this.dataList = null;
            } else if (this.dataListi.hasNext()) {
                this.dataList = this.dataListi.next();
            } else {
                this.finishDocument();
            }
        } else {
            this.getNextDocument();
        }
        if (retval == null && !this.isfinishedDocument()) {
            return this.getRow(rowMeta);
        }
        return retval;
    }

    private Object getValue(Object value, ValueMetaInterface valueMeta) {
        if (value == null) {
            return null;
        }
        Object o = null;
        if (value instanceof List) {
            value = this.getYaml().dump(value);
        }
        switch (valueMeta.getType()) {
            case 5: {
                if (value instanceof Integer) {
                    o = new Long(((Integer)value).intValue());
                    break;
                }
                if (value instanceof BigInteger) {
                    o = new Long(((BigInteger)value).longValue());
                    break;
                }
                if (value instanceof Long) {
                    o = new Long((Long)value);
                    break;
                }
                o = new Long(value.toString());
                break;
            }
            case 1: {
                if (value instanceof Integer) {
                    o = new Double(((Integer)value).intValue());
                    break;
                }
                if (value instanceof BigInteger) {
                    o = new Double(((BigInteger)value).doubleValue());
                    break;
                }
                if (value instanceof Long) {
                    o = new Double(((Long)value).longValue());
                    break;
                }
                if (value instanceof Double) {
                    o = (Double)value;
                    break;
                }
                o = new Double((String)value);
                break;
            }
            case 6: {
                if (value instanceof Integer) {
                    o = new BigDecimal((Integer)value);
                    break;
                }
                if (value instanceof BigInteger) {
                    o = new BigDecimal((BigInteger)value);
                    break;
                }
                if (value instanceof Long) {
                    o = new BigDecimal((Long)value);
                    break;
                }
                if (!(value instanceof Double)) break;
                o = new BigDecimal((Double)value);
                break;
            }
            case 4: {
                o = (Boolean)value;
                break;
            }
            case 3: {
                o = (java.util.Date)value;
                break;
            }
            case 8: {
                o = (byte[])value;
                break;
            }
            default: {
                String s = this.setMap(value);
                switch (valueMeta.getTrimType()) {
                    case 1: {
                        s = Const.ltrim((String)s);
                        break;
                    }
                    case 2: {
                        s = Const.rtrim((String)s);
                        break;
                    }
                    case 3: {
                        s = Const.trim((String)s);
                        break;
                    }
                }
                o = s;
            }
        }
        return o;
    }

    private void getNextDocument() {
        if (this.documenti.hasNext()) {
            this.document = this.documenti.next();
            if (!this.isMapUsed()) {
                List list = (List)this.getDocument();
                this.dataListi = list.iterator();
            }
        }
    }

    private String setMap(Object value) {
        String result = value.toString();
        if (value instanceof Map) {
            Map map = (Map)value;
            Iterator it = map.entrySet().iterator();
            int nr = 0;
            while (it.hasNext()) {
                Map.Entry pairs = it.next();
                String res = pairs.getKey().toString() + ":  " + this.setMap(pairs.getValue());
                result = nr == 0 ? "{" + res : result + "," + res;
                ++nr;
            }
            if (nr > 0) {
                result = result + "}";
            }
        }
        return result;
    }

    public RowMeta getFields() {
        RowMeta rowMeta = new RowMeta();
        for (Object data : this.documents) {
            if (data instanceof Map) {
                Map map = (Map)data;
                for (Map.Entry pairs : map.entrySet()) {
                    ValueMeta valueMeta = new ValueMeta(pairs.getKey().toString(), this.getType(pairs.getValue()));
                    rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
                }
                continue;
            }
            if (!(data instanceof List)) continue;
            rowMeta = new RowMeta();
            List list = (List)data;
            Iterator it = list.iterator();
            Map.Entry value = it.next();
            if (list.size() == 1) {
                Map map = (Map)((Object)value);
                for (Map.Entry pairs : map.entrySet()) {
                    ValueMeta valueMeta = new ValueMeta(pairs.getKey().toString(), this.getType(pairs.getValue()));
                    rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
                }
                continue;
            }
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(DEFAULT_LIST_VALUE_NAME, this.getType(value)));
        }
        return rowMeta;
    }

    private int getType(Object value) {
        if (value instanceof Integer) {
            return 5;
        }
        if (value instanceof Double) {
            return 1;
        }
        if (value instanceof Long) {
            return 5;
        }
        if (value instanceof java.util.Date) {
            return 3;
        }
        if (value instanceof Date) {
            return 3;
        }
        if (value instanceof Timestamp) {
            return 3;
        }
        if (value instanceof Boolean) {
            return 4;
        }
        if (value instanceof BigInteger) {
            return 6;
        }
        if (value instanceof BigDecimal) {
            return 6;
        }
        if (value instanceof Byte) {
            return 8;
        }
        return 2;
    }

    private Object getDocument() {
        return this.document;
    }

    private void finishDocument() {
        this.document = null;
    }

    private boolean isfinishedDocument() {
        return this.document == null;
    }

    public void close() throws Exception {
        if (this.file != null) {
            this.file.close();
        }
        this.documents = null;
        this.yaml = null;
    }

    public FileObject getFile() {
        return this.file;
    }

    public String getStringValue() {
        return this.string;
    }
}

