/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteServletInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddExportServlet
extends BaseHttpServlet
implements CarteServletInterface {
    public static final String PARAMETER_LOAD = "load";
    public static final String PARAMETER_TYPE = "type";
    public static final String TYPE_JOB = "job";
    public static final String TYPE_TRANS = "trans";
    private static final long serialVersionUID = -6850701762586992604L;
    public static final String CONTEXT_PATH = "/kettle/addExport";

    public AddExportServlet() {
    }

    public AddExportServlet(JobMap jobMap, TransformationMap transformationMap) {
        super(transformationMap, jobMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getRequestURI().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Addition of export requested");
        }
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        if (this.log.isDetailed()) {
            this.logDetailed("Encoding: " + request.getCharacterEncoding());
        }
        boolean isJob = TYPE_JOB.equalsIgnoreCase(request.getParameter(PARAMETER_TYPE));
        String load = request.getParameter(PARAMETER_LOAD);
        response.setContentType("text/xml");
        out.print(XMLHandler.getXMLHeader());
        response.setStatus(200);
        OutputStream outputStream = null;
        try {
            try {
                int c;
                FileObject tempFile = KettleVFS.createTempFile((String)"export", (String)".zip", (String)System.getProperty("java.io.tmpdir"));
                outputStream = KettleVFS.getOutputStream((FileObject)tempFile, (boolean)false);
                int size = 0;
                while ((c = in.read()) != -1) {
                    outputStream.write(c);
                    ++size;
                }
                outputStream.flush();
                outputStream.close();
                outputStream = null;
                String archiveUrl = tempFile.getName().toString();
                String fileUrl = null;
                String carteObjectId = null;
                SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
                if (!Const.isEmpty((String)load)) {
                    fileUrl = "zip:" + archiveUrl + "!" + load;
                    if (isJob) {
                        KettleVFS.getFileObject((String)fileUrl);
                        JobMeta jobMeta = new JobMeta(fileUrl, null);
                        String configUrl = "zip:" + archiveUrl + "!" + "__job_execution_configuration__.xml";
                        Document configDoc = XMLHandler.loadXMLFile((String)configUrl);
                        JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration(XMLHandler.getSubNode((Node)configDoc, (String)"job_execution_configuration"));
                        carteObjectId = UUID.randomUUID().toString();
                        servletLoggingObject.setContainerObjectId(carteObjectId);
                        servletLoggingObject.setLogLevel(jobExecutionConfiguration.getLogLevel());
                        Job job = new Job(null, jobMeta, (LoggingObjectInterface)servletLoggingObject);
                        this.getJobMap().addJob(job.getJobname(), carteObjectId, job, new JobConfiguration(jobMeta, jobExecutionConfiguration));
                        this.log.setLogLevel(jobExecutionConfiguration.getLogLevel());
                        jobMeta.setArguments(jobExecutionConfiguration.getArgumentStrings());
                        jobMeta.injectVariables(jobExecutionConfiguration.getVariables());
                        Map<String, String> params = jobExecutionConfiguration.getParams();
                        for (String param : params.keySet()) {
                            String value = params.get(param);
                            jobMeta.setParameterValue(param, value);
                        }
                    } else {
                        TransMeta transMeta = new TransMeta(fileUrl);
                        String configUrl = "zip:" + archiveUrl + "!" + "__job_execution_configuration__.xml";
                        Document configDoc = XMLHandler.loadXMLFile((String)configUrl);
                        TransExecutionConfiguration executionConfiguration = new TransExecutionConfiguration(XMLHandler.getSubNode((Node)configDoc, (String)"transformation_execution_configuration"));
                        carteObjectId = UUID.randomUUID().toString();
                        servletLoggingObject.setContainerObjectId(carteObjectId);
                        servletLoggingObject.setLogLevel(executionConfiguration.getLogLevel());
                        Trans trans = new Trans(transMeta, (LoggingObjectInterface)servletLoggingObject);
                        this.getTransformationMap().addTransformation(trans.getName(), carteObjectId, trans, new TransConfiguration(transMeta, executionConfiguration));
                    }
                } else {
                    fileUrl = archiveUrl;
                }
                out.println(new WebResult("OK", fileUrl, carteObjectId));
            }
            catch (Exception ex) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
                Object var25_31 = null;
                if (outputStream == null) return;
                outputStream.close();
                return;
            }
            Object var25_30 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var25_32 = null;
            if (outputStream == null) throw throwable;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    public String toString() {
        return "Add export";
    }

    public String getService() {
        return "/kettle/addExport (" + this.toString() + ")";
    }
}

