/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.www.Carte;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarteSingleton {
    private static Class<?> PKG = Carte.class;
    private static SlaveServerConfig slaveServerConfig;
    private static CarteSingleton carte;
    private LogChannelInterface log;
    private TransformationMap transformationMap;
    private JobMap jobMap;
    private List<SlaveServerDetection> detections;
    private SocketRepository socketRepository;

    private CarteSingleton(SlaveServerConfig config) throws KettleException {
        KettleEnvironment.init();
        CentralLogStore.init(config.getMaxLogLines(), config.getMaxLogTimeoutMinutes());
        this.log = new LogChannel((Object)"Carte");
        this.transformationMap = new TransformationMap();
        this.transformationMap.setSlaveServerConfig(config);
        this.jobMap = new JobMap();
        this.jobMap.setSlaveServerConfig(config);
        this.detections = new ArrayList<SlaveServerDetection>();
        this.socketRepository = new SocketRepository(this.log);
        CarteSingleton.installPurgeTimer(config, this.log, this.transformationMap, this.jobMap);
        SlaveServer slaveServer = config.getSlaveServer();
        if (slaveServer != null) {
            int port = 80;
            if (!Const.isEmpty((String)slaveServer.getPort())) {
                try {
                    port = Integer.parseInt(slaveServer.getPort());
                }
                catch (Exception e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"Carte.Error.CanNotPartPort", (String[])new String[]{slaveServer.getHostname(), "" + port}), (Throwable)e);
                }
            }
            if (config.isReportingToMasters()) {
                String hostname = slaveServer.getHostname();
                SlaveServer client = new SlaveServer("Dynamic slave [" + hostname + ":" + port + "]", hostname, "" + port, slaveServer.getUsername(), slaveServer.getPassword());
                for (SlaveServer master : config.getMasters()) {
                    try {
                        SlaveServerDetection slaveServerDetection = new SlaveServerDetection(client);
                        master.sendXML(slaveServerDetection.getXML(), "/kettle/registerSlave/");
                        this.log.logBasic("Registered this slave server to master slave server [" + master.toString() + "] on address [" + master.getServerAndPort() + "]");
                    }
                    catch (Exception e) {
                        this.log.logError("Unable to register to master slave server [" + master.toString() + "] on address [" + master.getServerAndPort() + "]");
                    }
                }
            }
        }
    }

    public static void installPurgeTimer(SlaveServerConfig config, final LogChannelInterface log, final TransformationMap transformationMap, final JobMap jobMap) {
        String systemTimeout = EnvUtil.getSystemProperty((String)"KETTLE_CARTE_OBJECT_TIMEOUT_MINUTES", null);
        final int objectTimeout = config.getObjectTimeoutMinutes() > 0 ? config.getObjectTimeoutMinutes() : (!Const.isEmpty((String)systemTimeout) ? Const.toInt((String)systemTimeout, (int)1440) : 1440);
        if (objectTimeout > 0) {
            log.logBasic("Installing timer to purge stale objects after " + objectTimeout + " minutes.");
            Timer timer = new Timer(true);
            final AtomicBoolean busy = new AtomicBoolean(false);
            TimerTask timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!busy.get()) {
                        busy.set(true);
                        try {
                            int diffInMinutes;
                            for (CarteObjectEntry entry : transformationMap.getTransformationObjects()) {
                                Trans trans = transformationMap.getTransformation(entry);
                                if (trans == null || !trans.isFinished() && !trans.isStopped() || trans.getLogDate() == null || (diffInMinutes = (int)Math.floor((System.currentTimeMillis() - trans.getLogDate().getTime()) / 60000L)) < objectTimeout) continue;
                                transformationMap.removeTransformation(entry);
                                LoggingRegistry.getInstance().removeIncludingChildren(trans.getLogChannelId());
                                CentralLogStore.discardLines(trans.getLogChannelId(), false);
                                log.logMinimal("Cleaned up transformation " + entry.getName() + " with id " + entry.getId() + " from " + trans.getLogDate() + ", diff=" + diffInMinutes);
                            }
                            for (CarteObjectEntry entry : jobMap.getJobObjects()) {
                                Job job = jobMap.getJob(entry);
                                if (job == null || !job.isFinished() && !job.isStopped() || job.getLogDate() == null || (diffInMinutes = (int)Math.floor((System.currentTimeMillis() - job.getLogDate().getTime()) / 60000L)) < objectTimeout) continue;
                                jobMap.removeJob(entry);
                                log.logMinimal("Cleaned up job " + entry.getName() + " with id " + entry.getId() + " from " + job.getLogDate());
                            }
                            Object var6_5 = null;
                            busy.set(false);
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            busy.set(false);
                            throw throwable;
                        }
                    }
                }
            };
            timer.schedule(timerTask, 20000L, 20000L);
        }
    }

    public static CarteSingleton getInstance() {
        try {
            if (carte == null) {
                if (slaveServerConfig == null) {
                    slaveServerConfig = new SlaveServerConfig();
                    SlaveServer slaveServer = new SlaveServer();
                    slaveServerConfig.setSlaveServer(slaveServer);
                }
                carte = new CarteSingleton(slaveServerConfig);
                Trans trans = Carte.generateTestTransformation();
                String carteObjectId = UUID.randomUUID().toString();
                SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject("CarteSingleton", LoggingObjectType.CARTE, null);
                servletLoggingObject.setContainerObjectId(carteObjectId);
                servletLoggingObject.setLogLevel(LogLevel.BASIC);
                carte.getTransformationMap().addTransformation(trans.getName(), carteObjectId, trans, new TransConfiguration(trans.getTransMeta(), new TransExecutionConfiguration()));
                return carte;
            }
            return carte;
        }
        catch (KettleException ke) {
            throw new RuntimeException(ke);
        }
    }

    public TransformationMap getTransformationMap() {
        return this.transformationMap;
    }

    public void setTransformationMap(TransformationMap transformationMap) {
        this.transformationMap = transformationMap;
    }

    public JobMap getJobMap() {
        return this.jobMap;
    }

    public void setJobMap(JobMap jobMap) {
        this.jobMap = jobMap;
    }

    public List<SlaveServerDetection> getDetections() {
        return this.detections;
    }

    public void setDetections(List<SlaveServerDetection> detections) {
        this.detections = detections;
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }

    public static SlaveServerConfig getSlaveServerConfig() {
        return slaveServerConfig;
    }

    public static void setSlaveServerConfig(SlaveServerConfig slaveServerConfig) {
        CarteSingleton.slaveServerConfig = slaveServerConfig;
    }
}

