/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.palo.core;

import org.pentaho.di.palo.core.DimensionGroupingCollection;
import org.pentaho.di.palo.core.ReadOnlyDimensionGroupingCollection;

public class DimensionGrouping {
    private final String id;
    private final String name;
    private final int level;
    private final DimensionGroupingCollection children;

    public DimensionGrouping(String name, String id) {
        this.name = name;
        this.id = id;
        this.level = 0;
        this.children = new DimensionGroupingCollection();
    }

    public DimensionGrouping(String name, String id, int level) {
        this.name = name;
        this.id = id;
        this.level = level;
        this.children = new DimensionGroupingCollection();
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final int getLevel() {
        return this.level;
    }

    public final DimensionGroupingCollection getChildren() {
        return new ReadOnlyDimensionGroupingCollection(this.children);
    }

    public final boolean containsChild(String name) {
        return this.children.contains(name);
    }

    public final DimensionGrouping findChild(String name) {
        return this.children.find(name);
    }

    public final void addChild(DimensionGrouping child) throws Exception {
        if (this.level != child.level + 1) {
            throw new Exception("Level of the child must be level of the parent - 1");
        }
        this.children.add(child);
    }

    public final boolean equals(Object o) {
        if (o instanceof DimensionGrouping) {
            return this.id.equals(((DimensionGrouping)o).id);
        }
        return false;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }
}

