/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.palo.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.palo.api.Connection;
import org.palo.api.ConnectionConfiguration;
import org.palo.api.ConnectionFactory;
import org.palo.api.Consolidation;
import org.palo.api.Cube;
import org.palo.api.Database;
import org.palo.api.Dimension;
import org.palo.api.Element;
import org.palo.api.ElementNode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseFactoryInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.palo.core.DimensionField;
import org.pentaho.di.palo.core.DimensionGrouping;
import org.pentaho.di.palo.core.DimensionGroupingCollection;
import org.pentaho.di.palo.core.PaloDimensionLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaloHelper
implements DatabaseFactoryInterface {
    public static boolean connectingToPalo = false;
    private Database database;
    private Connection connection;
    private DatabaseMeta databaseMeta;
    private final ListenersManager listeners;

    public PaloHelper() {
        this.listeners = new ListenersManager();
    }

    public PaloHelper(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
        this.listeners = new ListenersManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionTestReport(DatabaseMeta databaseMeta) throws KettleDatabaseException {
        StringBuffer report = new StringBuffer();
        PaloHelper helper = new PaloHelper(databaseMeta);
        try {
            helper.connect();
            report.append("Connecting to PALO server [").append(databaseMeta.getName()).append("] went without a problem.").append(Const.CR);
        }
        catch (KettleException e) {
            report.append("Unable to connect to the PALO server: ").append(e.getMessage()).append(Const.CR);
            report.append(Const.getStackTracker((Throwable)e));
        }
        finally {
            helper.disconnect();
        }
        return report.toString();
    }

    public final void connect() throws KettleException {
        while (connectingToPalo) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {}
        }
        assert (this.databaseMeta != null);
        try {
            connectingToPalo = true;
            ConnectionConfiguration connConfig = new ConnectionConfiguration(this.databaseMeta.getHostname(), this.databaseMeta.getDatabasePortNumberString());
            connConfig.setUser(this.databaseMeta.getUsername());
            connConfig.setPassword(this.databaseMeta.getPassword());
            connConfig.setLoadOnDemand(true);
            this.connection = ConnectionFactory.getInstance().newConnection(connConfig);
            this.database = this.connection.getDatabaseByName(this.databaseMeta.getDatabaseName());
            connectingToPalo = false;
            if (this.database == null) {
                throw new KettleException("The specified database with name '" + this.databaseMeta.getDatabaseName() + "' could not be found");
            }
        }
        catch (Exception e) {
            connectingToPalo = false;
            throw new KettleException("Unexpected error while connecting to the Palo server: " + e.getMessage(), (Throwable)e);
        }
    }

    public final List<String> getDimensionsNames() {
        Dimension dimension;
        int i;
        assert (this.database != null);
        ArrayList<String> names = new ArrayList<String>();
        for (i = 0; i < this.database.getDimensionCount(); ++i) {
            dimension = this.database.getDimensionAt(i);
            if (dimension.getName().startsWith("#")) continue;
            names.add(dimension.getName());
        }
        for (i = 0; i < this.database.getDimensionCount(); ++i) {
            dimension = this.database.getDimensionAt(i);
            if (!dimension.getName().startsWith("#")) continue;
            names.add(dimension.getName());
        }
        return names;
    }

    public final List<String> getCubesNames() {
        Cube cube;
        int i;
        assert (this.database != null);
        ArrayList<String> names = new ArrayList<String>();
        for (i = 0; i < this.database.getCubeCount(); ++i) {
            cube = this.database.getCubeAt(i);
            if (cube.isAttributeCube() || cube.isSubsetCube() || cube.isSystemCube() || cube.isUserInfoCube() || cube.isViewCube()) continue;
            names.add(cube.getName());
        }
        for (i = 0; i < this.database.getCubeCount(); ++i) {
            cube = this.database.getCubeAt(i);
            if (!cube.isAttributeCube() && !cube.isSubsetCube() && !cube.isSystemCube() && !cube.isUserInfoCube() && !cube.isViewCube()) continue;
            names.add(cube.getName());
        }
        return names;
    }

    public final List<String> getCubeDimensions(String cubeName) {
        assert (this.database != null);
        ArrayList<String> cubeDimensions = new ArrayList<String>();
        Cube cube = this.database.getCubeByName(cubeName);
        Dimension[] dimensions = cube.getDimensions();
        for (int i = 0; i < dimensions.length; ++i) {
            cubeDimensions.add(dimensions[i].getName());
        }
        return cubeDimensions;
    }

    public final RowMetaInterface getCellRowMeta(String cubeName, List<DimensionField> fields, DimensionField cubeMeasure) throws KettleException {
        Cube cube = this.database.getCubeByName(cubeName);
        RowMeta rowMeta = new RowMeta();
        Dimension[] dimensions = cube.getDimensions();
        for (int i = 0; i < dimensions.length; ++i) {
            DimensionField df = null;
            for (DimensionField d : fields) {
                if (!d.getDimensionName().equals(dimensions[i].getName())) continue;
                df = d;
                break;
            }
            if (df == null) {
                throw new KettleException("Dimension " + dimensions[i].getName() + " not found on  fields definition");
            }
            if (df.getFieldType().equals("String")) {
                rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(df.getFieldName(), 2));
                continue;
            }
            if (df.getFieldType().equals("Number")) {
                rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(df.getFieldName(), 1));
                continue;
            }
            throw new KettleException("Only String and Number Types are acepted dimension fields");
        }
        if (cubeMeasure == null) {
            throw new KettleException("Measure field not defined.");
        }
        if (cubeMeasure.getFieldType().equals("String")) {
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(cubeMeasure.getFieldName(), 2));
        } else if (cubeMeasure.getFieldType().equals("Number")) {
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(cubeMeasure.getFieldName(), 1));
        } else {
            throw new KettleException("Only String and Number Types are acepted Measure field");
        }
        return rowMeta;
    }

    public final RowMetaInterface getDimensionRowMeta(String dimensionName, List<PaloDimensionLevel> levels) throws KettleException {
        Dimension dimension = this.database.getDimensionByName(dimensionName);
        RowMeta rowMeta = new RowMeta();
        if (dimension.getDefaultHierarchy().getMaxLevel() + 1 != levels.size()) {
            throw new KettleException("Levels of the dimension differ from defined levels");
        }
        for (int i = 0; i <= dimension.getDefaultHierarchy().getMaxLevel(); ++i) {
            String fieldName = levels.get(i).getFieldName();
            if (fieldName == null || fieldName == "") {
                fieldName = dimensionName;
            }
            int type = -1;
            if (levels.get(i).getFieldType().equals("String")) {
                type = 2;
            } else if (levels.get(i).getFieldType().equals("Number")) {
                type = 1;
            } else {
                throw new KettleException("Only String and Number Types are acepted dimension fields");
            }
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(fieldName, type));
        }
        return rowMeta;
    }

    public final List<PaloDimensionLevel> getDimensionLevels(String dimensionName) throws KettleException {
        ArrayList<PaloDimensionLevel> levels = new ArrayList<PaloDimensionLevel>();
        Dimension dimension = this.database.getDimensionByName(dimensionName);
        if (dimension == null) {
            throw new KettleException("Dimension " + dimensionName + " does not exist");
        }
        for (int i = 0; i <= dimension.getDefaultHierarchy().getMaxLevel(); ++i) {
            levels.add(new PaloDimensionLevel("Level " + i, i, "", ""));
        }
        return levels;
    }

    public final List<Object[]> getDimensionRows(String dimensionName, RowMetaInterface rowMeta, Listener listener) throws KettleException {
        assert (this.database != null);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Dimension dimension = this.database.getDimensionByName(dimensionName);
        if (dimension == null) {
            throw new KettleException("Unable to find dimension '" + dimensionName + "' in the Palo database");
        }
        int rowSize = dimension.getDefaultHierarchy().getMaxDepth() + 1;
        ElementNode[] elementsTree = dimension.getDefaultHierarchy().getElementsTree();
        Object[] row = new Object[rowSize];
        this.listeners.prepareElements(elementsTree.length);
        for (ElementNode node : elementsTree) {
            this.showChildren(node);
            this.assembleDimensionRows(rows, row, rowSize, dimension, node, 0, rowMeta, listener);
            this.listeners.oneMoreElement(node);
        }
        return rows;
    }

    public final void disconnect() {
        assert (this.connection != null);
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public final DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public final void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public final Database getDatabase() {
        return this.database;
    }

    public final void setDatabase(Database database) {
        this.database = database;
    }

    public final DimensionGroupingCollection getConsolidations(String dimensionName, List<String[]> tableInputDimensions) throws Exception {
        if (tableInputDimensions.size() == 0) {
            throw new Exception("Invalid Data. Number of rows must be > 0");
        }
        int rowsCount = tableInputDimensions.size();
        int columnsCount = tableInputDimensions.get(0).length;
        if (columnsCount == 0) {
            throw new Exception("Invalid data. Incoming column count must be > 0");
        }
        DimensionGroupingCollection currentLevel = null;
        int groupNumber = 0;
        for (int col = columnsCount - 1; col >= 0; --col) {
            DimensionGroupingCollection previousLevel = currentLevel;
            currentLevel = new DimensionGroupingCollection();
            for (int row = 0; row < rowsCount; ++row) {
                String childName;
                DimensionGrouping c;
                String group = tableInputDimensions.get(row)[col];
                if (!currentLevel.contains(group)) {
                    if (col != columnsCount - 1) {
                        c = new DimensionGrouping(group, "Group ".concat(String.valueOf(groupNumber)), columnsCount - col - 1);
                        ++groupNumber;
                    } else {
                        c = new DimensionGrouping(group, dimensionName, columnsCount - col - 1);
                    }
                    currentLevel.add(c);
                } else {
                    c = currentLevel.find(group);
                }
                if (col == columnsCount - 1 || c.containsChild(childName = tableInputDimensions.get(row)[col + 1])) continue;
                c.addChild(previousLevel.find(childName));
            }
        }
        return currentLevel;
    }

    public final void addDimension(String dimensionName, DimensionGroupingCollection dimension, boolean createIfNotExists, boolean clearDimension, boolean clearConsolidations, String elementType) throws KettleException {
        Dimension dim = this.database.getDimensionByName(dimensionName);
        if (dim == null) {
            if (createIfNotExists) {
                dim = this.database.addDimension(dimensionName);
            } else {
                throw new KettleException("The dimension " + dimensionName + " does not exist.");
            }
        }
        if (clearConsolidations) {
            ArrayList<Element> toDeleteArr = new ArrayList<Element>();
            for (Element e : dim.getDefaultHierarchy().getElements()) {
                if (e.getChildCount() <= 0) continue;
                toDeleteArr.add(e);
            }
            if (toDeleteArr.size() > 0) {
                dim.getDefaultHierarchy().removeElements(toDeleteArr.toArray(new Element[0]));
            }
        }
        if (clearDimension) {
            dim.getDefaultHierarchy().removeElements(dim.getDefaultHierarchy().getElements());
        }
        for (DimensionGrouping d : dimension) {
            this.addDimensionGrouping(dimensionName, d, elementType);
        }
    }

    public final void removeDimension(String dimensionName) {
        Dimension dim = this.database.getDimensionByName(dimensionName);
        this.database.removeDimension(dim);
    }

    public final void removeCube(String cubeName) {
        Cube cube = this.database.getCubeByName(cubeName);
        this.database.removeCube(cube);
    }

    public final void createCube(String cubeName, String[] dimensionsNames) {
        Dimension[] dims = new Dimension[dimensionsNames.length];
        for (int i = 0; i < dimensionsNames.length; ++i) {
            dims[i] = this.database.getDimensionByName(dimensionsNames[i]);
        }
        this.database.addCube(cubeName, dims);
    }

    public final void clearCube(String cubeName) throws Exception {
        Cube cube = this.database.getCubeByName(cubeName);
        if (cube == null) {
            throw new Exception("The cube " + cubeName + " does not exist.");
        }
        cube.clear();
    }

    public final void addCells(String cubeName, List<Object[]> cells) throws Exception {
        if (cells.size() == 0) {
            throw new Exception("Data Array size must be > 0");
        }
        if (cells.get(0).length < 2) {
            throw new Exception("Data Array must be wider that 1 column");
        }
        Cube cube = this.database.getCubeByName(cubeName);
        if (cube == null) {
            throw new Exception("The cube " + cubeName + " does not exist.");
        }
        for (int i = 0; i < cells.size(); ++i) {
            String[] dimensions = new String[cells.get(0).length - 1];
            for (int j = 0; j < cells.get(i).length - 1; ++j) {
                dimensions[j] = cells.get(i)[j].toString();
                Dimension d = cube.getDimensionAt(j);
                if (d == null) {
                    throw new Exception("The cube does not have so many dimensions");
                }
                if (d.getDefaultHierarchy().getElementByName(dimensions[j]) != null) continue;
                throw new Exception("The dimension element " + dimensions[j] + " does not exist in dimension " + d.getName());
            }
            Object dataValue = cells.get(i)[cells.get(i).length - 1];
            try {
                if (dataValue instanceof Double) {
                    cube.setData(dimensions, (Object)((Double)dataValue));
                    continue;
                }
                if (dataValue instanceof String) {
                    cube.setData(dimensions, (Object)((String)dataValue));
                    continue;
                }
                throw new Exception("Cell value must be a Double or String to write it to Palo.");
            }
            catch (Exception ex) {
                String row = "";
                for (int k = 0; k < dimensions.length; ++k) {
                    row = row + " " + dimensions[k].toString();
                }
                row = row + " " + dataValue.toString();
                throw ex;
            }
        }
    }

    public final List<Object[]> getCells(String cubeName) {
        final ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Listener listener = new Listener(){
            private boolean stop;
            private boolean cancel;

            public void oneMoreElement(Object element) {
                rows.add((Object[])element);
            }

            public void prepareElements(int elements) {
            }

            public void stop() {
                this.stop = true;
            }

            public void resume() {
                this.stop = false;
            }

            public boolean getStop() {
                return this.stop;
            }

            public void cancel() {
                this.cancel = true;
            }

            public boolean getCancel() {
                return this.cancel;
            }
        };
        try {
            List<String> dimensions = this.getCubeDimensions(cubeName);
            ArrayList<DimensionField> fields = new ArrayList<DimensionField>();
            for (String s : dimensions) {
                fields.add(new DimensionField(s, s, "String"));
            }
            RowMetaInterface rowMeta = this.getCellRowMeta(cubeName, fields, new DimensionField("Measure", "Measure", "Number"));
            this.getCells(cubeName, rowMeta, listener);
        }
        catch (Exception e) {
            return null;
        }
        return rows;
    }

    public final void getCells(String cubeName, RowMetaInterface rowMeta, Listener listener) throws KettleException {
        Cube cube = this.database.getCubeByName(cubeName);
        Dimension[] cubeDimensions = cube.getDimensions();
        Element[][] cubeDimensionElements = new Element[cubeDimensions.length][];
        int[] currentDimensionIndexes = new int[cubeDimensions.length];
        int totalElements = 1;
        for (int i = 0; i < cubeDimensions.length; ++i) {
            Element[] elements = cubeDimensions[i].getDefaultHierarchy().getElements();
            ArrayList<Element> list = new ArrayList<Element>();
            for (int j = 0; j < elements.length; ++j) {
                if (elements[j].getType() == 2) continue;
                list.add(elements[j]);
            }
            cubeDimensionElements[i] = list.toArray(new Element[list.size()]);
            currentDimensionIndexes[i] = 0;
            totalElements *= cubeDimensionElements[i].length;
        }
        Element[] coordinates = new Element[cubeDimensions.length];
        this.listeners.prepareElements(totalElements);
        do {
            Object[] row = new Object[cubeDimensions.length + 1];
            for (int i = 0; i < cubeDimensions.length; ++i) {
                coordinates[i] = cubeDimensionElements[i][currentDimensionIndexes[i]];
                if (rowMeta.getValueMeta(i).isString()) {
                    row[i] = coordinates[i].getName();
                    continue;
                }
                if (rowMeta.getValueMeta(i).isNumber()) {
                    row[i] = Double.parseDouble(coordinates[i].getName());
                    continue;
                }
                throw new KettleException("Only String and Number Types are allowed for dimension values");
            }
            Object data = cube.getData(coordinates);
            if (rowMeta.getValueMeta(cubeDimensions.length).isString()) {
                if (!(data instanceof String) || !data.toString().equals("")) {
                    row[cubeDimensions.length] = data.toString();
                    this.listeners.oneMoreElement(row);
                    listener.oneMoreElement(row);
                }
            } else if (rowMeta.getValueMeta(cubeDimensions.length).isNumber()) {
                if (data instanceof Double) {
                    row[cubeDimensions.length] = data;
                    this.listeners.oneMoreElement(row);
                    listener.oneMoreElement(row);
                } else if (!(data instanceof String) || !data.toString().equals("")) {
                    throw new KettleException("Measure field is defined as Number but data from palo is: " + data.getClass().toString());
                }
            } else {
                throw new KettleException("Only String and Number Types are accepted for Measure Field");
            }
            if (!listener.getStop()) continue;
            while (listener.getStop() && !listener.getCancel()) {
            }
        } while (!listener.getCancel() && this.iterateElements(currentDimensionIndexes, cubeDimensionElements));
    }

    public final void createDatabase(String databaseName) {
        assert (this.database != null);
        this.connection.addDatabase(databaseName);
    }

    public final void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private boolean isDimension(String elementName) {
        List<String> dims = this.getDimensionsNames();
        for (String s : dims) {
            if (!s.equals(elementName)) continue;
            return true;
        }
        return false;
    }

    private void showChildren(ElementNode node) {
        System.out.println("Leido un elemento: " + node.getElement().getName() + " level: " + node.getElement().getLevel() + " hijo de :" + node.getElement().getName());
        Element e = node.getElement();
        Consolidation[] consolidations = e.getConsolidations();
        System.out.println("TYPE " + e.getTypeAsString());
        if (this.isDimension(e.getName())) {
            System.out.println(e.getName() + " IS A DIMENSION");
        }
        for (int i = 0; i < consolidations.length; ++i) {
            System.out.println("CONSOLIDATION: CHILD: " + consolidations[i].getChild().getName() + " PARENT: " + consolidations[i].getParent().getName());
        }
        System.out.println("__________________________________________________");
        for (ElementNode childrenNode : node.getChildren()) {
            this.showChildren(childrenNode);
        }
    }

    private void assembleDimensionRows(List<Object[]> rows, Object[] currentRow, int rowSize, Dimension dimension, ElementNode node, int rowIndex, RowMetaInterface rowMeta, Listener listener) throws KettleException {
        switch (node.getElement().getType()) {
            case 0: 
            case 1: 
            case 2: {
                if (rowMeta.getValueMeta(rowIndex).isNumber()) {
                    try {
                        currentRow[rowIndex] = Double.parseDouble(node.getElement().getName());
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleException("Failed to cast Palo Element to Number Type", (Throwable)e);
                    }
                }
                if (rowMeta.getValueMeta(rowIndex).isString()) {
                    currentRow[rowIndex] = node.getElement().getName();
                    break;
                }
                throw new KettleException("Invalid Metadata type for dimension level. Must be Number or String");
            }
            default: {
                throw new KettleException("Invalid Dimension Element Palo Type: " + node.getElement().getType());
            }
        }
        ElementNode[] children = node.getChildren();
        if (children != null && children.length != 0) {
            for (int i = 0; i < children.length; ++i) {
                this.assembleDimensionRows(rows, currentRow, rowSize, dimension, children[i], rowIndex + 1, rowMeta, listener);
            }
        } else {
            Object[] clonedRow = new Object[currentRow.length];
            for (int i = 0; i < currentRow.length; ++i) {
                clonedRow[i] = currentRow[i];
            }
            rows.add(clonedRow);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addDimensionGrouping(String dimensionName, DimensionGrouping dimensionGrouping, String elementType) throws KettleException {
        if (dimensionGrouping.getChildren().size() == 0) {
            Dimension dim = this.database.getDimensionByName(dimensionName);
            try {
                if (dim.getDefaultHierarchy().getElementByName(dimensionGrouping.getName()) != null) return;
                if (elementType.equals("Numeric")) {
                    dim.getDefaultHierarchy().addElement(dimensionGrouping.getName(), 0);
                    return;
                }
                dim.getDefaultHierarchy().addElement(dimensionGrouping.getName(), 1);
                return;
            }
            catch (Exception e) {
                throw new KettleException("Failed to create element: " + dimensionGrouping.getName(), (Throwable)e);
            }
        }
        for (DimensionGrouping d : dimensionGrouping.getChildren()) {
            this.addDimensionGrouping(dimensionName, d, elementType);
        }
        Dimension dim = this.database.getDimensionByName(dimensionName);
        try {
            int i;
            Element parentElement = dim.getDefaultHierarchy().getElementByName(dimensionGrouping.getName());
            if (parentElement == null) {
                parentElement = dim.getDefaultHierarchy().addElement(dimensionGrouping.getName(), 0);
            }
            ArrayList<Consolidation> newConsolidations = new ArrayList<Consolidation>();
            for (i = 0; i < parentElement.getConsolidationCount(); ++i) {
                newConsolidations.add(parentElement.getConsolidationAt(i));
            }
            for (i = 0; i < dimensionGrouping.getChildren().size(); ++i) {
                Element childElement = dim.getDefaultHierarchy().getElementByName(((DimensionGrouping)dimensionGrouping.getChildren().get(i)).getName());
                boolean found = false;
                for (Consolidation c : newConsolidations) {
                    if (!c.getChild().getName().equals(((DimensionGrouping)dimensionGrouping.getChildren().get(i)).getName())) continue;
                    found = true;
                }
                if (found) continue;
                newConsolidations.add(dim.getDefaultHierarchy().newConsolidation(childElement, parentElement, 1.0));
            }
            Consolidation[] finalConsolidations = new Consolidation[newConsolidations.size()];
            for (int i2 = 0; i2 < finalConsolidations.length; ++i2) {
                finalConsolidations[i2] = (Consolidation)newConsolidations.get(i2);
            }
            parentElement.updateConsolidations(finalConsolidations);
            return;
        }
        catch (Exception e) {
            throw new KettleException("failed to create consolidation: " + dimensionGrouping.getName(), (Throwable)e);
        }
    }

    private boolean iterateElements(int[] currentDimensionIndexes, Element[][] cubeDimensionElements) {
        for (int i = currentDimensionIndexes.length - 1; i >= 0; --i) {
            if (currentDimensionIndexes[i] + 1 == cubeDimensionElements[i].length) {
                currentDimensionIndexes[i] = 0;
                if (i != 0) continue;
                return false;
            }
            int n = i;
            currentDimensionIndexes[n] = currentDimensionIndexes[n] + 1;
            break;
        }
        return true;
    }

    private final class ListenersManager {
        private final Set<Listener> listeners = new HashSet<Listener>();

        private ListenersManager() {
        }

        public void add(Listener listener) {
            this.listeners.add(listener);
        }

        public void remove(Listener listener) {
            this.listeners.remove(listener);
        }

        public void oneMoreElement(Object element) {
            for (Listener l : this.listeners) {
                l.oneMoreElement(element);
            }
        }

        public void prepareElements(int maxNumberOfElements) {
            for (Listener l : this.listeners) {
                l.prepareElements(maxNumberOfElements);
            }
        }
    }

    public static interface Listener {
        public void oneMoreElement(Object var1);

        public void prepareElements(int var1);

        public boolean getStop();

        public void stop();

        public void cancel();

        public void resume();

        public boolean getCancel();
    }
}

