/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding.manual;

import java.util.Locale;
import org.pentaho.reporting.libraries.fonts.encoding.ByteBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.ByteStream;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointStream;
import org.pentaho.reporting.libraries.fonts.encoding.ComplexEncoding;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingErrorType;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingException;

public class Utf16LE
implements ComplexEncoding {
    public static final int MAX_CHAR = 1114109;
    private static Utf16LE instance;

    public static synchronized Utf16LE getInstance() {
        if (instance == null) {
            instance = new Utf16LE();
        }
        return instance;
    }

    public String getName() {
        return "UTF-16LE";
    }

    public String getName(Locale locale) {
        return "UTF-16LE";
    }

    public boolean isUnicodeCharacterSupported(int c) {
        return c > 0 && c < 1114109 && (c & 0xFFFFF800) == 55296;
    }

    public ByteBuffer encode(CodePointBuffer text, ByteBuffer buffer) {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new ByteBuffer(textLength * 2);
        } else if (buffer.getLength() * 2 < textLength) {
            buffer.ensureSize(textLength * 2);
        }
        ByteStream target = new ByteStream(buffer, textLength);
        int[] sourceArray = text.getData();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            int sourceItem = sourceArray[i];
            if (sourceItem < 0 || sourceItem > 1114109) continue;
            if (sourceItem <= 65535) {
                if (sourceItem >= 55296 && sourceItem <= 57343) continue;
                target.put((byte)((sourceItem & 0xFF00) >> 8));
                target.put((byte)(sourceItem & 0xFF));
                continue;
            }
            int derivedSourceItem = sourceItem - 65536;
            int highWord = 0xD800 | (derivedSourceItem & 0xFFC00) >> 10;
            target.put((byte)((highWord & 0xFF00) >> 8));
            target.put((byte)(highWord & 0xFF));
            int lowWord = 0xDC00 | derivedSourceItem & 0x3FF;
            target.put((byte)((lowWord & 0xFF00) >> 8));
            target.put((byte)(lowWord & 0xFF));
        }
        target.close();
        return buffer;
    }

    public CodePointBuffer decode(ByteBuffer text, CodePointBuffer buffer) {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new CodePointBuffer(textLength / 2);
        } else if (buffer.getLength() / 2 < textLength) {
            buffer.ensureSize(textLength / 2);
        }
        int[] targetData = buffer.getData();
        ByteStream sourceBuffer = new ByteStream(text, 10);
        int position = buffer.getOffset();
        while (sourceBuffer.getReadSize() >= 2) {
            int highByte = sourceBuffer.get() & 0xFF;
            int lowByte = sourceBuffer.get() & 0xFF;
            if ((highByte & 0xFC) == 216) {
                if (sourceBuffer.getReadSize() < 2) break;
                int highByteL = sourceBuffer.get() & 0xFF;
                int lowByteL = sourceBuffer.get() & 0xFF;
                if ((highByteL & 0xFC) != 220) continue;
                int result = lowByteL;
                result |= (highByteL & 3) << 8;
                result |= lowByte << 10;
                targetData[position] = (result |= (highByte & 3) << 18) + 65536;
                ++position;
                continue;
            }
            if ((highByte & 0xFC) == 220) continue;
            targetData[position] = highByte << 8 | lowByte;
            ++position;
        }
        buffer.setCursor(position);
        return buffer;
    }

    public ByteBuffer encode(CodePointBuffer text, ByteBuffer buffer, EncodingErrorType errorHandling) throws EncodingException {
        return this.encode(text, buffer);
    }

    public CodePointBuffer decode(ByteBuffer text, CodePointBuffer buffer, EncodingErrorType errorHandling) throws EncodingException {
        return this.decode(text, buffer);
    }

    public boolean isEncodingSupported() {
        return true;
    }

    public CodePointBuffer decodeString(String text, CodePointBuffer buffer) {
        char[] chars = text.toCharArray();
        int textLength = chars.length;
        return this.decode(chars, 0, textLength, buffer);
    }

    public CodePointBuffer decode(char[] chars, int offset, int length, CodePointBuffer buffer) {
        if (buffer == null) {
            buffer = new CodePointBuffer(length);
        } else if (buffer.getLength() < length) {
            buffer.ensureSize(length);
        }
        CodePointStream cps = new CodePointStream(buffer, 10);
        int maxPos = offset + length;
        for (int i = offset; i < maxPos; ++i) {
            char c = chars[i];
            if ((c & 0xFC00) == 55296) {
                if (++i >= maxPos) break;
                char c2 = chars[i];
                if ((c2 & 0xFC00) != 56320) continue;
                int codePoint = 65536 + (c2 & 0x3FF | (c & 0x3FF) << 10);
                cps.put(codePoint);
                continue;
            }
            cps.put(c);
        }
        cps.close();
        return buffer;
    }

    public String encodeString(CodePointBuffer buffer) {
        StringBuilder stringBuffer = new StringBuilder(buffer.getLength() * 3 / 2);
        int[] data = buffer.getData();
        int endPos = buffer.getCursor();
        for (int i = buffer.getOffset(); i < endPos; ++i) {
            int codePoint = data[i];
            if (codePoint < 65536) {
                stringBuffer.append((char)codePoint);
                continue;
            }
            int derivedSourceItem = codePoint - 65536;
            int highWord = 0xD800 | (derivedSourceItem & 0xFFC00) >> 10;
            int lowWord = 0xDC00 | derivedSourceItem & 0x3FF;
            stringBuffer.append((char)highWord);
            stringBuffer.append((char)lowWord);
        }
        return stringBuffer.toString();
    }
}

