/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.itext;

import com.lowagie.text.pdf.BaseFont;
import java.util.Arrays;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointUtilities;
import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontNativeContext;
import org.pentaho.reporting.libraries.fonts.tools.StrictGeomUtility;

public class BaseFontFontMetrics
implements FontMetrics {
    private BaseFont baseFont;
    private float size;
    private long xHeight;
    private char[] cpBuffer;
    private long[] cachedWidths;
    private long ascent;
    private long descent;
    private long leading;
    private long sizeScaled;
    private long italicsAngle;
    private long maxAscent;
    private long maxDescent;
    private long maxCharAdvance;
    private boolean trueTypeFont;
    private transient BaselineInfo cachedBaselineInfo;
    private FontNativeContext record;

    public BaseFontFontMetrics(FontNativeContext record, BaseFont baseFont, float size) {
        if (baseFont == null) {
            throw new NullPointerException("BaseFont is invalid.");
        }
        this.record = record;
        this.baseFont = baseFont;
        this.size = size;
        this.cpBuffer = new char[4];
        this.cachedWidths = new long[224];
        Arrays.fill(this.cachedWidths, -1L);
        this.sizeScaled = StrictGeomUtility.toInternalValue(size);
        this.ascent = (long)baseFont.getFontDescriptor(9, (float)this.sizeScaled);
        this.descent = (long)(-baseFont.getFontDescriptor(10, (float)this.sizeScaled));
        this.leading = (long)baseFont.getFontDescriptor(11, (float)this.sizeScaled);
        this.italicsAngle = StrictGeomUtility.toInternalValue(baseFont.getFontDescriptor(4, size));
        this.maxAscent = (long)baseFont.getFontDescriptor(8, (float)this.sizeScaled);
        this.maxDescent = (long)(-baseFont.getFontDescriptor(6, (float)this.sizeScaled));
        this.maxCharAdvance = (long)baseFont.getFontDescriptor(12, (float)this.sizeScaled);
        int[] charBBox = this.baseFont.getCharBBox(120);
        if (charBBox != null) {
            this.xHeight = (long)((float)charBBox[3] * size);
        }
        if (this.xHeight == 0L) {
            this.xHeight = this.getAscent() / 2L;
        }
        this.trueTypeFont = baseFont.getFontType() == 1 || baseFont.getFontType() == 3;
    }

    public boolean isTrueTypeFont() {
        return this.trueTypeFont;
    }

    public long getAscent() {
        return this.ascent;
    }

    public long getDescent() {
        return this.descent;
    }

    public long getLeading() {
        return this.leading;
    }

    public long getXHeight() {
        return this.xHeight;
    }

    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, this.sizeScaled / 20L);
    }

    public long getUnderlinePosition() {
        return this.getLeading() + this.getMaxAscent() + Math.max(1000L, this.sizeScaled / 20L);
    }

    public long getStrikeThroughPosition() {
        return this.getMaxAscent() - (long)(0.5 * (double)this.getXHeight());
    }

    public long getItalicAngle() {
        return this.italicsAngle;
    }

    public long getMaxAscent() {
        return this.maxAscent;
    }

    public long getMaxDescent() {
        return this.maxDescent;
    }

    public long getMaxHeight() {
        return this.getMaxAscent() + this.getMaxDescent() + this.getLeading();
    }

    public long getMaxCharAdvance() {
        return this.maxCharAdvance;
    }

    public long getCharWidth(int character) {
        if (character >= 32 && character < 256) {
            long width;
            int index = character - 32;
            long cachedWidth = this.cachedWidths[index];
            if (cachedWidth >= 0L) {
                return cachedWidth;
            }
            int retval = CodePointUtilities.toChars(character, this.cpBuffer, 0);
            if (retval == 1) {
                char char1 = this.cpBuffer[0];
                if (char1 < '\u0080' || char1 >= '\u00a0' && char1 <= '\u00ff') {
                    long width2;
                    this.cachedWidths[index] = width2 = (long)((float)this.baseFont.getWidth((int)char1) * this.size);
                    return width2;
                }
            } else if (retval < 1) {
                this.cachedWidths[index] = 0L;
                return 0L;
            }
            this.cachedWidths[index] = width = (long)((float)this.baseFont.getWidth(new String(this.cpBuffer, 0, retval)) * this.size);
            return width;
        }
        int retval = CodePointUtilities.toChars(character, this.cpBuffer, 0);
        if (retval == 1) {
            char char1 = this.cpBuffer[0];
            if (char1 < '\u0080' || char1 >= '\u00a0' && char1 <= '\u00ff') {
                return (long)((float)this.baseFont.getWidth((int)char1) * this.size);
            }
        } else if (retval < 1) {
            return 0L;
        }
        return (long)((float)this.baseFont.getWidth(new String(this.cpBuffer, 0, retval)) * this.size);
    }

    public long getKerning(int previous, int codePoint) {
        return (long)(this.size * (float)this.baseFont.getKerning((int)((char)previous), (int)((char)codePoint)));
    }

    public boolean isUniformFontMetrics() {
        return true;
    }

    public BaselineInfo getBaselines(int c, BaselineInfo info) {
        if (this.cachedBaselineInfo != null) {
            if (info == null) {
                info = new BaselineInfo();
            }
            info.update(this.cachedBaselineInfo);
            return info;
        }
        if (info == null) {
            info = new BaselineInfo();
        }
        long maxAscent = this.getMaxAscent();
        info.setBaseline(1, maxAscent - this.getXHeight());
        info.setBaseline(5, this.getMaxHeight());
        info.setBaseline(3, maxAscent / 2L);
        info.setBaseline(4, maxAscent);
        info.setBaseline(2, maxAscent / 2L);
        info.setBaseline(0, maxAscent - this.getXHeight());
        info.setDominantBaseline(4);
        BaselineInfo cached = new BaselineInfo();
        cached.update(info);
        this.cachedBaselineInfo = cached;
        return info;
    }

    public BaseFont getBaseFont() {
        return this.baseFont;
    }

    public FontNativeContext getNativeContext() {
        return this.record;
    }
}

