/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.itext;

import com.lowagie.text.pdf.BaseFont;
import org.pentaho.reporting.libraries.fonts.itext.BaseFontFontMetrics;
import org.pentaho.reporting.libraries.fonts.itext.BaseFontSupport;
import org.pentaho.reporting.libraries.fonts.itext.ITextFontRegistry;
import org.pentaho.reporting.libraries.fonts.merge.CompoundFontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontNativeContext;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontIdentifier;

public class ITextFontMetricsFactory
implements FontMetricsFactory {
    private BaseFontSupport baseFontSupport;

    public ITextFontMetricsFactory(ITextFontRegistry registry) {
        this.baseFontSupport = new BaseFontSupport(registry);
    }

    public void close() {
        this.baseFontSupport.close();
    }

    public FontMetrics createMetrics(FontIdentifier identifier, FontContext context) {
        boolean italic;
        boolean bold;
        String fontName;
        FontIdentifier record;
        CompoundFontIdentifier compoundFontIdentifier;
        if (identifier instanceof CompoundFontIdentifier) {
            compoundFontIdentifier = (CompoundFontIdentifier)identifier;
            record = compoundFontIdentifier.getIdentifier();
        } else {
            record = identifier;
            compoundFontIdentifier = null;
        }
        if (record instanceof FontRecord) {
            FontRecord fontRecord = (FontRecord)((Object)record);
            fontName = fontRecord.getFamily().getFamilyName();
            if (compoundFontIdentifier != null) {
                bold = compoundFontIdentifier.isBoldSpecified();
                italic = compoundFontIdentifier.isItalicsSpecified();
            } else {
                bold = fontRecord.isBold();
                italic = fontRecord.isItalic();
            }
        } else if (record instanceof TrueTypeFontIdentifier) {
            TrueTypeFontIdentifier ttfFontRecord = (TrueTypeFontIdentifier)record;
            fontName = ttfFontRecord.getFontName();
            if (compoundFontIdentifier != null) {
                bold = compoundFontIdentifier.isBoldSpecified();
                italic = compoundFontIdentifier.isItalicsSpecified();
            } else {
                bold = false;
                italic = false;
            }
        } else {
            throw new IllegalArgumentException("Unknown font-identifier type encountered.");
        }
        BaseFont baseFont = this.baseFontSupport.createBaseFont(fontName, bold, italic, context.getEncoding(), context.isEmbedded());
        return new BaseFontFontMetrics(new DefaultFontNativeContext(bold, italic), baseFont, (float)context.getFontSize());
    }
}

