/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.Serializable;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontNativeContext;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class TrueTypeFontIdentifier
implements FontIdentifier,
Serializable,
FontNativeContext {
    private String fontSource;
    private String fontName;
    private String fontVariant;
    private int collectionIndex;
    private long offset;
    private boolean italics;
    private boolean bold;

    public TrueTypeFontIdentifier(String fontSource, String fontName, String fontVariant, int collectionIndex, long offset, boolean italics, boolean bold) {
        this.italics = italics;
        this.bold = bold;
        if (fontSource == null) {
            throw new NullPointerException();
        }
        if (fontName == null) {
            throw new NullPointerException();
        }
        if (fontVariant == null) {
            throw new NullPointerException();
        }
        this.fontVariant = fontVariant;
        this.fontSource = fontSource;
        this.fontName = fontName;
        this.collectionIndex = collectionIndex;
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrueTypeFontIdentifier that = (TrueTypeFontIdentifier)o;
        if (this.collectionIndex != that.collectionIndex) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (!this.fontSource.equals(that.fontSource)) {
            return false;
        }
        if (!this.fontName.equals(that.fontName)) {
            return false;
        }
        return this.fontVariant.equals(that.fontVariant);
    }

    public int hashCode() {
        int result = this.fontName.hashCode();
        result = 29 * result + this.fontSource.hashCode();
        result = 29 * result + this.fontVariant.hashCode();
        result = 29 * result + this.collectionIndex;
        result = 29 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }

    public String getFontSource() {
        return this.fontSource;
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean isScalable() {
        return true;
    }

    public FontType getFontType() {
        return FontType.OPENTYPE;
    }

    public boolean isNativeBold() {
        return this.bold;
    }

    public boolean isNativeItalics() {
        return this.italics;
    }
}

