/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.fonts.io.FileFontDataInputSource;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontType;
import org.pentaho.reporting.libraries.fonts.truetype.ScalableTrueTypeFontMetrics;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontIdentifier;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontMetrics;

public class TrueTypeFontMetricsFactory
implements FontMetricsFactory {
    private static final Log logger = LogFactory.getLog(TrueTypeFontMetricsFactory.class);
    private HashMap<TrueTypeFontIdentifier, ScalableTrueTypeFontMetrics> fontRecords = new HashMap();

    public FontMetrics createMetrics(FontIdentifier record, FontContext context) {
        if (!FontType.OPENTYPE.equals(record.getFontType())) {
            throw new IllegalArgumentException("This identifier does not belong to the OpenType-font system.");
        }
        TrueTypeFontIdentifier ttfId = (TrueTypeFontIdentifier)record;
        ScalableTrueTypeFontMetrics fromCache = this.fontRecords.get(ttfId);
        if (fromCache != null) {
            return new TrueTypeFontMetrics(ttfId, fromCache, context.getFontSize());
        }
        try {
            String fontSource = ttfId.getFontSource();
            FileFontDataInputSource fdis = new FileFontDataInputSource(new File(fontSource));
            TrueTypeFont font = new TrueTypeFont(fdis);
            ScalableTrueTypeFontMetrics fontMetrics = new ScalableTrueTypeFontMetrics(font);
            this.fontRecords.put(ttfId, fontMetrics);
            return new TrueTypeFontMetrics(ttfId, fontMetrics, context.getFontSize());
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to read the font.", (Throwable)e);
            throw new IllegalStateException();
        }
    }
}

