/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hdfs.vfs;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.pentaho.hdfs.vfs.HDFSFileSystem;

public class MapRFileSystem
extends HDFSFileSystem
implements org.apache.commons.vfs.FileSystem {
    private FileSystem fs;

    public MapRFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, fileSystemOptions);
    }

    public FileSystem getHDFSFileSystem() throws FileSystemException {
        if (this.fs == null) {
            Configuration conf = new Configuration();
            conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
            GenericFileName rootName = (GenericFileName)this.getRootName();
            String url = rootName.getScheme() + "://" + rootName.getHostName().trim();
            if (rootName.getPort() != -1) {
                url = url + ":" + rootName.getPort();
            }
            url = url + "/";
            conf.set("fs.default.name", url);
            try {
                this.fs = FileSystem.get((Configuration)conf);
            }
            catch (Throwable t) {
                throw new FileSystemException("Could not get MapR FileSystem for " + url, t);
            }
        }
        return this.fs;
    }
}

