/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import org.osjava.sj.loader.convert.ConvertRegistry;
import org.osjava.sj.loader.convert.Converter;
import org.osjava.sj.loader.util.AbstractProperties;
import org.osjava.sj.loader.util.CustomProperties;
import org.osjava.sj.loader.util.IniProperties;
import org.osjava.sj.loader.util.Utils;
import org.osjava.sj.loader.util.XmlProperties;

public class JndiLoader {
    public static final String SIMPLE_DELIMITER = "org.osjava.sj.delimiter";
    public static final String SIMPLE_SHARED = "org.osjava.sj.shared";
    public static final String SIMPLE_COLON_REPLACE = "org.osjava.sj.colon.replace";
    private static ConvertRegistry convertRegistry = new ConvertRegistry();
    private Hashtable table = new Hashtable();

    public JndiLoader() {
        this.table.put(SIMPLE_DELIMITER, "/");
    }

    public JndiLoader(Hashtable env) {
        if (!env.containsKey(SIMPLE_DELIMITER)) {
            throw new IllegalArgumentException("The property org.osjava.sj.delimiter is mandatory. ");
        }
        this.table.put(SIMPLE_DELIMITER, env.get(SIMPLE_DELIMITER));
        if (env.containsKey(SIMPLE_COLON_REPLACE)) {
            this.table.put(SIMPLE_COLON_REPLACE, env.get(SIMPLE_COLON_REPLACE));
        }
    }

    public void putParameter(String key, String value) {
        this.table.put(key, value);
    }

    public String getParameter(String key) {
        return (String)this.table.get(key);
    }

    public void loadDirectory(File directory, Context ctxt) throws NamingException, IOException {
        this.loadDirectory(directory, ctxt, null, "");
    }

    public void loadDirectory(File directory, Context ctxt, Context parentCtxt, String ctxtName) throws NamingException, IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("java.io.File parameter must be a directory. [" + directory + "]");
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String name = file.getName();
            String colonReplace = (String)this.table.get(SIMPLE_COLON_REPLACE);
            if (colonReplace != null && name.indexOf(colonReplace) != -1) {
                name = Utils.replace(name, colonReplace, ":");
            }
            if (file.isDirectory()) {
                if (name.equals(".svn") || name.equals("CVS")) continue;
                Context tmpCtxt = ctxt.createSubcontext(name);
                this.loadDirectory(file, tmpCtxt, ctxt, name);
                continue;
            }
            String[] extensions = new String[]{".properties", ".ini", ".xml"};
            for (int j = 0; j < extensions.length; ++j) {
                String extension = extensions[j];
                if (!file.getName().endsWith(extension)) continue;
                Context tmpCtxt = ctxt;
                if (!file.getName().equals("default" + extension)) {
                    name = name.substring(0, name.length() - extension.length());
                    tmpCtxt = ctxt.createSubcontext(name);
                    parentCtxt = ctxt;
                    ctxtName = name;
                }
                this.load(this.loadFile(file), tmpCtxt, parentCtxt, ctxtName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadFile(File file) throws IOException {
        AbstractProperties p = null;
        p = file.getName().endsWith(".xml") ? new XmlProperties() : (file.getName().endsWith(".ini") ? new IniProperties() : new CustomProperties());
        p.setDelimiter((String)this.table.get(SIMPLE_DELIMITER));
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            p.load(fin);
            AbstractProperties abstractProperties = p;
            return abstractProperties;
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    public void load(Properties properties, Context ctxt) throws NamingException {
        this.load(properties, ctxt, null, "");
    }

    public void load(Properties properties, Context ctxt, Context parentCtxt, String ctxtName) throws NamingException {
        String key;
        String delimiter = (String)this.table.get(SIMPLE_DELIMITER);
        String typePostfix = delimiter + "type";
        HashMap<String, Properties> typeMap = new HashMap<String, Properties>();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            if (!key.equals("type") && !key.endsWith(typePostfix)) continue;
            Properties tmp = new Properties();
            tmp.put("type", properties.get(key));
            if (key.equals("type")) {
                typeMap.put("", tmp);
                continue;
            }
            typeMap.put(key.substring(0, key.length() - typePostfix.length()), tmp);
        }
        iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            Object value = properties.get(key);
            if (key.equals("type") || key.endsWith(typePostfix)) continue;
            if (typeMap.containsKey(key)) {
                ((Properties)typeMap.get(key)).put("", value);
                continue;
            }
            if (key.indexOf(delimiter) != -1) {
                String pathText = JndiLoader.removeLastElement(key, delimiter);
                String nodeText = JndiLoader.getLastElement(key, delimiter);
                if (typeMap.containsKey(pathText)) {
                    ((Properties)typeMap.get(pathText)).put(nodeText, value);
                    continue;
                }
            } else if (typeMap.containsKey("")) {
                ((Properties)typeMap.get("")).put(key, value);
                continue;
            }
            this.jndiPut(ctxt, key, properties.get(key));
        }
        Iterator typeIterator = typeMap.keySet().iterator();
        while (typeIterator.hasNext()) {
            String typeKey = (String)typeIterator.next();
            Properties typeProperties = (Properties)typeMap.get(typeKey);
            Object value = JndiLoader.convert(typeProperties);
            if (typeKey.equals("")) {
                this.jndiPut(parentCtxt, ctxtName, value);
                continue;
            }
            this.jndiPut(ctxt, typeKey, value);
        }
    }

    private void jndiPut(Context ctxt, String key, Object value) throws NamingException {
        String[] path = Utils.split(key, (String)this.table.get(SIMPLE_DELIMITER));
        int lastIndex = path.length - 1;
        Context tmpCtxt = ctxt;
        for (int i = 0; i < lastIndex; ++i) {
            Object obj = tmpCtxt.lookup(path[i]);
            if (obj == null) {
                tmpCtxt = tmpCtxt.createSubcontext(path[i]);
                continue;
            }
            if (obj instanceof Context) {
                tmpCtxt = (Context)obj;
                continue;
            }
            throw new RuntimeException("Illegal node/branch clash. At branch value '" + path[i] + "' an Object was found: " + obj);
        }
        Object obj = tmpCtxt.lookup(path[lastIndex]);
        if (obj instanceof Context) {
            tmpCtxt.destroySubcontext(path[lastIndex]);
            obj = null;
        }
        if (obj == null) {
            tmpCtxt.bind(path[lastIndex], value);
        } else {
            tmpCtxt.rebind(path[lastIndex], value);
        }
    }

    private static Object convert(Properties properties) {
        String type = properties.getProperty("type");
        String converterClassName = properties.getProperty("converter");
        if (converterClassName != null) {
            try {
                Class<?> converterClass = Class.forName(converterClassName);
                Converter converter = (Converter)converterClass.newInstance();
                return converter.convert(properties, type);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unable to find class: " + converterClassName, cnfe);
            }
            catch (IllegalAccessException ie) {
                throw new RuntimeException("Unable to access class: " + type, ie);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException("Unable to create Converter " + type + " via empty constructor. ", ie);
            }
        }
        Converter converter = convertRegistry.getConverter(type);
        if (converter != null) {
            return converter.convert(properties, type);
        }
        return properties.get("");
    }

    private static String getLastElement(String str, String delimiter) {
        int idx = str.lastIndexOf(delimiter);
        return str.substring(idx + 1);
    }

    private static String removeLastElement(String str, String delimiter) {
        int idx = str.lastIndexOf(delimiter);
        return str.substring(0, idx);
    }
}

