/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.osjava.sj.loader.PoolSetup;

public class SJDataSource
implements DataSource {
    private PrintWriter pw;
    private String username;
    private String password;
    private String url;
    private String driver;
    private String pool;

    public SJDataSource(String driver, String url, String username, String password, String pool) {
        SJDataSource.ensureLoaded(driver);
        this.driver = driver;
        this.url = url;
        this.pw = new PrintWriter(System.err);
        this.username = username;
        this.password = password;
        this.pool = pool;
    }

    private static boolean ensureLoaded(String name) {
        try {
            Class.forName(name).newInstance();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.username, this.password);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        String tmpUrl = this.url;
        if (this.pool != null) {
            System.err.println("[DS]Setting Pool information");
            PoolSetup.setupConnection(this.pool, this.url, username, password);
            tmpUrl = PoolSetup.getUrl(this.pool);
        }
        System.err.println("[DS]Getting Connection for url: " + tmpUrl);
        if (username == null || password == null) {
            return DriverManager.getConnection(tmpUrl);
        }
        return DriverManager.getConnection(tmpUrl, username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.pw;
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.pw = pw;
    }

    public void setLoginTimeout(int timeout) throws SQLException {
    }

    public String toString() {
        return this.driver + "::::" + this.url + "::::" + this.username;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SJDataSource other = (SJDataSource)obj;
        return other.url.equals(this.url) && other.driver.equals(this.driver) && other.username.equals(this.username);
    }

    public int hashCode() {
        return this.url.hashCode() & this.username.hashCode() & this.driver.hashCode();
    }
}

