/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle;

import java.net.URL;
import java.util.Map;
import org.pentaho.reporting.libraries.docbundle.bundleloader.RepositoryResourceBundleLoader;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.resourceloader.DefaultResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.ResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.UnrecognizedLoaderException;

public class BundleResourceManagerBackend
extends DefaultResourceManagerBackend {
    private ResourceManagerBackend backend;
    private RepositoryResourceBundleLoader loader;
    private ResourceKey outsideContextKey;

    public BundleResourceManagerBackend(Repository repository, ResourceManagerBackend backend, ResourceKey outsideContextKey) {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (backend == null) {
            throw new NullPointerException();
        }
        this.backend = backend;
        this.outsideContextKey = outsideContextKey;
        this.loader = new RepositoryResourceBundleLoader(repository, outsideContextKey);
    }

    public ResourceKey getOutsideContextKey() {
        return this.outsideContextKey;
    }

    public ResourceKey getBundleMainKey() {
        return this.loader.getMainKey();
    }

    public ResourceKey createKey(Object data, Map parameters) throws ResourceKeyCreationException {
        if (data == null) {
            throw new NullPointerException();
        }
        return this.backend.createKey(data, parameters);
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map parameters) throws ResourceKeyCreationException {
        if (parent == null) {
            if (path == null) {
                throw new NullPointerException();
            }
            return this.createKey(path, parameters);
        }
        if (this.loader.isSupportedKey(parent)) {
            try {
                return this.loader.deriveKey(parent, path, parameters);
            }
            catch (ResourceKeyCreationException rkce) {
                ResourceKey context = this.computeContextKey(parent);
                while (context != null) {
                    try {
                        return this.backend.deriveKey(context, path, parameters);
                    }
                    catch (ResourceKeyCreationException rkce2) {
                        rkce = rkce2;
                        context = this.computeContextKey(context);
                    }
                }
                throw rkce;
            }
        }
        return this.backend.deriveKey(parent, path, parameters);
    }

    private ResourceKey computeContextKey(ResourceKey key) {
        ResourceKey maybeParent;
        for (maybeParent = key.getParent(); maybeParent != null && this.loader.isSupportedKey(maybeParent); maybeParent = maybeParent.getParent()) {
        }
        return maybeParent;
    }

    public URL toURL(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.backend.toURL(key);
    }

    public Resource create(ResourceManager frontEnd, ResourceData data, ResourceKey context, Class[] target) throws ResourceLoadingException, ResourceCreationException {
        if (frontEnd == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        return this.backend.create(frontEnd, data, context, target);
    }

    public ResourceBundleData loadResourceBundle(ResourceManager frontEnd, ResourceKey key) throws ResourceLoadingException {
        if (frontEnd == null) {
            throw new NullPointerException();
        }
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.loader.isSupportedKey(key)) {
            return this.loader.loadBundle(frontEnd, key);
        }
        return this.backend.loadResourceBundle(frontEnd, key);
    }

    public void registerDefaultFactories() {
        this.backend.registerDefaultFactories();
    }

    public void registerDefaultLoaders() {
        this.backend.registerDefaultLoaders();
    }

    public void registerBundleLoader(ResourceBundleLoader loader) {
        this.backend.registerBundleLoader(loader);
    }

    public void registerLoader(ResourceLoader loader) {
        this.backend.registerLoader(loader);
    }

    public void registerFactory(ResourceFactory factory) {
        this.backend.registerFactory(factory);
    }

    public ResourceData loadRawData(ResourceManager frontEnd, ResourceKey key) throws ResourceLoadingException, UnrecognizedLoaderException {
        return this.backend.loadRawData(frontEnd, key);
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String serializedKey) throws ResourceKeyCreationException {
        if (this.loader.isSupportedDeserializer(serializedKey)) {
            return this.loader.deserialize(bundleKey, serializedKey);
        }
        return this.backend.deserialize(bundleKey, serializedKey);
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        if (this.loader.isSupportedKey(key)) {
            return this.loader.serialize(bundleKey, key);
        }
        String serializedVersion = this.backend.serialize(bundleKey, key);
        if (serializedVersion != null) {
            return serializedVersion;
        }
        return super.serialize(bundleKey, key);
    }
}

