/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.docbundle.BundleResourceManagerBackend;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.StaticDocumentMetaData;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.ResourceManagerBackend;

public class StaticDocumentBundle
implements DocumentBundle {
    private static final Log logger = LogFactory.getLog(StaticDocumentBundle.class);
    private StaticDocumentMetaData documentMetaData;
    private Repository repository;
    private ResourceManager resourceManager;
    private ResourceKey bundleKey;

    public StaticDocumentBundle(Repository repository, ResourceManager resourceManager, ResourceKey outsideContextKey) throws ResourceException {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
        BundleResourceManagerBackend backend = new BundleResourceManagerBackend(repository, resourceManager.getBackend(), outsideContextKey);
        this.bundleKey = backend.getBundleMainKey();
        this.resourceManager = new ResourceManager(resourceManager, (ResourceManagerBackend)backend);
        this.documentMetaData = new StaticDocumentMetaData(this.resourceManager, this.bundleKey);
    }

    public StaticDocumentBundle(Repository repository) throws ResourceException {
        this(repository, StaticDocumentBundle.createDefaultResourceManager(), null);
    }

    private static ResourceManager createDefaultResourceManager() {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        return resourceManager;
    }

    public DocumentMetaData getMetaData() {
        return this.documentMetaData;
    }

    public boolean isEntryExists(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String[] splitName = RepositoryUtilities.split((String)name, (String)"/");
        try {
            return RepositoryUtilities.isExistsEntity((Repository)this.repository, (String[])splitName);
        }
        catch (ContentIOException e) {
            return false;
        }
    }

    public boolean isEntryReadable(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            String[] splitName = RepositoryUtilities.split((String)name, (String)"/");
            ContentEntity contentEntity = RepositoryUtilities.getEntity((Repository)this.repository, (String[])splitName);
            return contentEntity instanceof ContentItem;
        }
        catch (ContentIOException cioe) {
            return false;
        }
    }

    public InputStream getEntryAsStream(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            String[] splitName = RepositoryUtilities.split((String)name, (String)"/");
            ContentEntity contentEntity = RepositoryUtilities.getEntity((Repository)this.repository, (String[])splitName);
            if (contentEntity instanceof ContentItem) {
                ContentItem contentItem = (ContentItem)contentEntity;
                return contentItem.getInputStream();
            }
        }
        catch (ContentIOException cioe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to lookup entry for entry " + name), (Throwable)cioe);
            }
            throw new IOException("Failure while looking up the stream: " + (Object)((Object)cioe));
        }
        throw new IOException("No such stream: " + name);
    }

    public String getEntryMimeType(String name) {
        block5: {
            if (name == null) {
                throw new NullPointerException();
            }
            String definedMimeType = this.documentMetaData.getEntryMimeType(name);
            if (definedMimeType != null) {
                return definedMimeType;
            }
            try {
                String[] splitName = RepositoryUtilities.split((String)name, (String)"/");
                ContentEntity contentEntity = RepositoryUtilities.getEntity((Repository)this.repository, (String[])splitName);
                if (contentEntity instanceof ContentItem) {
                    ContentItem contentItem = (ContentItem)contentEntity;
                    return contentItem.getMimeType();
                }
            }
            catch (ContentIOException cioe) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)("Failed to lookup entry mime-type for entry " + name), (Throwable)cioe);
            }
        }
        return "";
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ResourceKey getBundleKey() {
        return this.bundleKey;
    }
}

