/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle;

import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.metadata.BundleManifest;
import org.pentaho.reporting.libraries.docbundle.metadata.BundleMetaData;
import org.pentaho.reporting.libraries.docbundle.metadata.DefaultBundleMetaData;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class StaticDocumentMetaData
implements DocumentMetaData {
    private String bundleType;
    private BundleMetaData metaData;
    private BundleManifest manifest;
    private ResourceManager resourceManager;
    private ResourceKey bundleKey;

    public StaticDocumentMetaData(ResourceManager resourceManager, ResourceKey bundleKey) throws ResourceException {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (bundleKey == null) {
            throw new NullPointerException();
        }
        this.resourceManager = resourceManager;
        this.bundleKey = bundleKey;
        ResourceKey manifestDataKey = resourceManager.deriveKey(bundleKey, "/META-INF/manifest.xml");
        Resource manifestDataResource = resourceManager.create(manifestDataKey, null, BundleManifest.class);
        this.manifest = (BundleManifest)manifestDataResource.getResource();
        this.metaData = this.createMetaData(resourceManager, bundleKey);
        this.bundleType = this.readBundleType();
        if (this.bundleType == null) {
            this.bundleType = this.manifest.getMimeType("/");
        }
    }

    private BundleMetaData createMetaData(ResourceManager resourceManager, ResourceKey bundleKey) throws ResourceException {
        try {
            ResourceKey metaDataKey = resourceManager.deriveKey(bundleKey, "/meta.xml");
            ResourceData metaDataBytes = resourceManager.load(metaDataKey);
            Resource metaDataResource = resourceManager.create(metaDataKey, null, BundleMetaData.class);
            return (BundleMetaData)metaDataResource.getResource();
        }
        catch (ResourceKeyCreationException e) {
            return new DefaultBundleMetaData();
        }
        catch (ResourceLoadingException e) {
            return new DefaultBundleMetaData();
        }
    }

    private String readBundleType() {
        try {
            ResourceKey mimeKey = this.resourceManager.deriveKey(this.bundleKey, "mimetype");
            ResourceData mimeData = this.resourceManager.load(mimeKey);
            byte[] data = mimeData.getResource(this.resourceManager);
            return new String(data, "ASCII");
        }
        catch (Exception cioe) {
            return null;
        }
    }

    public String getBundleType() {
        return this.bundleType;
    }

    public String getEntryMimeType(String entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        return this.manifest.getMimeType(entry);
    }

    public Object getBundleAttribute(String namespace, String attributeName) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if (attributeName == null) {
            throw new NullPointerException();
        }
        return this.metaData.getBundleAttribute(namespace, attributeName);
    }

    public String[] getManifestEntryNames() {
        return this.manifest.getEntries();
    }

    public String[] getMetaDataNamespaces() {
        return this.metaData.getNamespaces();
    }

    public String[] getMetaDataNames(String namespace) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        return this.metaData.getNames(namespace);
    }

    public String getEntryAttribute(String entryName, String attributeName) {
        return this.manifest.getAttribute(entryName, attributeName);
    }

    public String[] getEntryAttributeNames(String entryName) {
        return this.manifest.getAttributeNames(entryName);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

