/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.bundleloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;

public class DirectoryResourceLoader
implements ResourceLoader {
    public boolean isSupportedKey(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return DirectoryResourceLoader.class.getName().equals(key.getSchema());
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        File f;
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof File) {
            File f2 = (File)value;
            if (f2.exists() && f2.isDirectory()) {
                return new ResourceKey((Object)DirectoryResourceLoader.class.getName(), (Object)f2, factoryKeys);
            }
        } else if (value instanceof String && (f = new File(String.valueOf(value))).exists() && f.isDirectory()) {
            return new ResourceKey((Object)DirectoryResourceLoader.class.getName(), (Object)f, factoryKeys);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        if (parent == null) {
            throw new NullPointerException();
        }
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        try {
            HashMap map;
            File target;
            if (path != null) {
                File parentResource = (File)parent.getIdentifier();
                target = new File(parentResource.getCanonicalFile().getParentFile(), path);
                if (!target.exists() || !target.isDirectory()) {
                    throw new ResourceKeyCreationException("Malformed value: " + path + " (" + target + ')');
                }
            } else {
                target = (File)parent.getIdentifier();
            }
            if (factoryKeys != null) {
                map = new HashMap();
                map.putAll(parent.getFactoryParameters());
                map.putAll(factoryKeys);
            } else {
                map = parent.getFactoryParameters();
            }
            return new ResourceKey(parent.getSchema(), (Object)target, map);
        }
        catch (IOException ioe) {
            throw new ResourceKeyCreationException("Failed to create key", (Exception)ioe);
        }
    }

    public URL toURL(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        File file = (File)key.getIdentifier();
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        throw new ResourceLoadingException("This resource Loader cannot be used to create a ResourceData object.");
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        throw new ResourceKeyCreationException("This resource Loader cannot be used to deserialize ReousrceKeys");
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        throw new ResourceException("This resource Loader cannot be used to serialize ResourceKeys");
    }

    public boolean isSupportedDeserializer(String data) {
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }
}

