/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.metadata.parser;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.metadata.UserDefinedAttribute;
import org.pentaho.reporting.libraries.docbundle.metadata.parser.BundleMetaDataEntryReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UserDefinedMetaDataEntryReadHandler
extends AbstractXmlReadHandler
implements BundleMetaDataEntryReadHandler {
    private String name;
    private String valueType;
    private String value;

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.name = attrs.getValue("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "name");
        this.valueType = attrs.getValue("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "value-type");
        this.value = attrs.getValue("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value");
    }

    public Object getObject() {
        if ("float".equals(this.valueType)) {
            try {
                return new BigDecimal(this.value);
            }
            catch (NumberFormatException nfe) {
                try {
                    double val = new Double(this.value);
                    return new BigDecimal(val);
                }
                catch (NumberFormatException nfe2) {
                    return null;
                }
            }
        }
        if ("date".equals(this.valueType)) {
            return BundleUtilities.parseDate(this.value);
        }
        if ("time".equals(this.valueType)) {
            return BundleUtilities.parseDuration(this.value);
        }
        if ("boolean".equals(this.valueType)) {
            if (this.value.equals("true")) {
                return new UserDefinedAttribute(this.name, Boolean.TRUE);
            }
            return new UserDefinedAttribute(this.name, Boolean.FALSE);
        }
        return new UserDefinedAttribute(this.name, this.value);
    }

    public String getMetaDataNameSpace() {
        return this.getUri();
    }

    public String getMetaDataName() {
        return this.getTagName();
    }
}

