/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.metadata.writer;

import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.reporting.libraries.docbundle.metadata.UserDefinedAttribute;
import org.pentaho.reporting.libraries.docbundle.metadata.writer.BundleMetaDataEntryWriteHandler;
import org.pentaho.reporting.libraries.docbundle.metadata.writer.BundleMetaDataXmlWriter;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class UserDefinedAttributeWriteHandler
implements BundleMetaDataEntryWriteHandler {
    public void write(BundleMetaDataXmlWriter bundleWriter, XmlWriter writer, String entryNamespace, String entryName, Object entry) throws IOException {
        if (bundleWriter == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (entryName == null) {
            throw new NullPointerException();
        }
        if (entryNamespace == null) {
            throw new NullPointerException();
        }
        if (entry == null) {
            throw new NullPointerException();
        }
        if (!entry.getClass().isArray()) {
            return;
        }
        int size = Array.getLength(entry);
        for (int i = 0; i < size; ++i) {
            String value;
            SimpleDateFormat sdf;
            String valueType;
            UserDefinedAttribute userDefinedAttribute;
            Object o;
            Object entryValue = Array.get(entry, i);
            if (!(entryValue instanceof UserDefinedAttribute)) {
                return;
            }
            AttributeList attributeList = new AttributeList();
            if (!writer.isNamespaceDefined(entryNamespace)) {
                String defaultNamespace = bundleWriter.getDefaultPrefix(entryNamespace);
                if (defaultNamespace != null && !writer.isNamespacePrefixDefined(defaultNamespace)) {
                    attributeList.addNamespaceDeclaration(defaultNamespace, entryNamespace);
                } else {
                    attributeList.addNamespaceDeclaration("autoGenNs", entryNamespace);
                }
            }
            if ((o = (userDefinedAttribute = (UserDefinedAttribute)entryValue).getValue()) instanceof Time) {
                valueType = "time";
                sdf = new SimpleDateFormat("'PT'HH'H'mm'M'ss'S'");
                value = sdf.format(o);
            } else if (o instanceof Date) {
                valueType = "date";
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss' 'z");
                value = sdf.format(o);
            } else if (o instanceof Number) {
                value = o.toString();
                valueType = "float";
            } else if (o instanceof Boolean) {
                value = o.toString();
                valueType = "boolean";
            } else if (o != null) {
                value = o.toString();
                valueType = "string";
            } else {
                return;
            }
            attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "name", userDefinedAttribute.getName());
            attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", valueType);
            writer.writeTag(entryNamespace, entryName, attributeList, false);
            writer.writeTextNormalized(value, false);
            writer.writeCloseTag();
        }
    }
}

