/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.table.TableModel;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKettleTransformationProducer
implements KettleTransformationProducer {
    private String stepName;
    private String username;
    private String password;
    private String repositoryName;
    private String[] definedArgumentNames;
    private ParameterMapping[] definedVariableNames;
    private transient Trans currentlyRunningTransformation;
    private boolean stopOnError;

    public AbstractKettleTransformationProducer(String repositoryName, String stepName, String username, String password, String[] definedArgumentNames, ParameterMapping[] definedVariableNames) {
        if (repositoryName == null) {
            throw new NullPointerException();
        }
        if (definedArgumentNames == null) {
            throw new NullPointerException();
        }
        if (definedVariableNames == null) {
            throw new NullPointerException();
        }
        this.repositoryName = repositoryName;
        this.stepName = stepName;
        this.username = username;
        this.password = password;
        this.definedArgumentNames = (String[])definedArgumentNames.clone();
        this.definedVariableNames = (ParameterMapping[])definedVariableNames.clone();
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public String getStepName() {
        return this.stepName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String[] getDefinedArgumentNames() {
        return (String[])this.definedArgumentNames.clone();
    }

    public ParameterMapping[] getDefinedVariableNames() {
        return (ParameterMapping[])this.definedVariableNames.clone();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractKettleTransformationProducer prod = (AbstractKettleTransformationProducer)super.clone();
        prod.definedArgumentNames = (String[])this.definedArgumentNames.clone();
        prod.definedVariableNames = (ParameterMapping[])this.definedVariableNames.clone();
        prod.currentlyRunningTransformation = null;
        return prod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableModel performQuery(DataRow parameters, int queryLimit, ResourceManager resourceManager, ResourceKey resourceKey) throws KettleException, ReportDataFactoryException {
        if (this.getStepName() == null) {
            throw new ReportDataFactoryException("No step name defined.");
        }
        String[] params = this.fillArguments(parameters);
        LogWriter logWriter = LogWriter.getInstance((String)"Kettle-reporting-datasource", (boolean)false);
        try {
            TableModel tableModel;
            block11: {
                Repository repository = this.connectToRepository(logWriter);
                try {
                    TransMeta transMeta = this.loadTransformation(repository, resourceManager, resourceKey);
                    transMeta.setArguments(params);
                    Trans trans = new Trans(transMeta);
                    for (int i = 0; i < this.definedVariableNames.length; ++i) {
                        ParameterMapping mapping = this.definedVariableNames[i];
                        String sourceName = mapping.getName();
                        String variableName = mapping.getAlias();
                        Object value = parameters.get(sourceName);
                        if (value == null) continue;
                        trans.setParameterValue(variableName, String.valueOf(value));
                    }
                    transMeta.setInternalKettleVariables();
                    trans.prepareExecution(transMeta.getArguments());
                    TableProducer tableProducer = null;
                    List stepList = trans.getSteps();
                    for (int i = 0; i < stepList.size(); ++i) {
                        StepMetaDataCombi metaDataCombi = (StepMetaDataCombi)stepList.get(i);
                        if (!this.stepName.equals(metaDataCombi.stepname)) continue;
                        RowMetaInterface row = transMeta.getStepFields(this.stepName);
                        tableProducer = new TableProducer(row, queryLimit, this.stopOnError);
                        metaDataCombi.step.addRowListener((RowListener)tableProducer);
                        break;
                    }
                    if (tableProducer == null) {
                        throw new ReportDataFactoryException("Cannot find the specified transformation step " + this.stepName);
                    }
                    this.currentlyRunningTransformation = trans;
                    trans.startThreads();
                    trans.waitUntilFinished();
                    trans.cleanup();
                    tableModel = tableProducer.getTableModel();
                    this.currentlyRunningTransformation = null;
                    if (repository == null) break block11;
                }
                catch (Throwable throwable) {
                    this.currentlyRunningTransformation = null;
                    if (repository != null) {
                        repository.disconnect();
                    }
                    throw throwable;
                }
                repository.disconnect();
            }
            return tableModel;
        }
        finally {
            logWriter.close();
        }
    }

    private String[] fillArguments(DataRow parameters) {
        String[] params = new String[this.definedArgumentNames.length];
        for (int i = 0; i < this.definedArgumentNames.length; ++i) {
            String name = this.definedArgumentNames[i];
            Object value = parameters.get(name);
            params[i] = value == null ? null : String.valueOf(value);
        }
        return params;
    }

    private Repository connectToRepository(LogWriter logWriter) throws ReportDataFactoryException, KettleException {
        if (logWriter == null) {
            throw new NullPointerException();
        }
        if (this.repositoryName == null) {
            throw new NullPointerException();
        }
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        try {
            repositoriesMeta.readData();
        }
        catch (KettleException ke) {
            // empty catch block
        }
        RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(this.repositoryName);
        if (repositoryMeta == null) {
            return null;
        }
        Repository repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
        repository.init(repositoryMeta);
        repository.connect(this.username, this.password);
        return repository;
    }

    protected abstract TransMeta loadTransformation(Repository var1, ResourceManager var2, ResourceKey var3) throws ReportDataFactoryException, KettleException;

    @Override
    public void cancelQuery() {
        Trans currentlyRunningTransformation = this.currentlyRunningTransformation;
        if (currentlyRunningTransformation != null) {
            currentlyRunningTransformation.stopAll();
            this.currentlyRunningTransformation = null;
        }
    }

    @Override
    public String[] getReferencedFields() {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        retval.addAll(Arrays.asList(this.definedArgumentNames));
        for (ParameterMapping parameter : this.definedVariableNames) {
            retval.add(parameter.getName());
        }
        retval.add("::org.pentaho.reporting::query-limit");
        return retval.toArray(new String[retval.size()]);
    }

    protected ArrayList<Object> internalGetQueryHash() {
        ArrayList<Object> retval = new ArrayList<Object>();
        retval.add(this.getClass().getName());
        retval.add(this.getUsername());
        retval.add(this.getPassword());
        retval.add(this.getStepName());
        retval.add(this.isStopOnError());
        retval.add(this.getRepositoryName());
        retval.add(new ArrayList<String>(Arrays.asList(this.getDefinedArgumentNames())));
        retval.add(new ArrayList<ParameterMapping>(Arrays.asList(this.getDefinedVariableNames())));
        return retval;
    }

    protected static class TableProducer
    implements RowListener {
        private TypedTableModel tableModel;
        private int rowsWritten;
        private RowMetaInterface rowMeta;
        private int queryLimit;
        private boolean stopOnError;
        private boolean firstCall;
        private boolean error;

        private TableProducer(RowMetaInterface rowMeta, int queryLimit, boolean stopOnError) {
            this.rowMeta = rowMeta;
            this.queryLimit = queryLimit;
            this.stopOnError = stopOnError;
            this.firstCall = true;
        }

        public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            if (this.firstCall) {
                this.tableModel = this.createTableModel(rowMeta);
                this.firstCall = false;
            }
            if (this.queryLimit > 0 && this.rowsWritten > this.queryLimit) {
                return;
            }
            try {
                ++this.rowsWritten;
                int count = this.tableModel.getColumnCount();
                Object[] dataRow = new Object[count];
                block13: for (int columnNo = 0; columnNo < count; ++columnNo) {
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(columnNo);
                    switch (valueMeta.getType()) {
                        case 6: {
                            dataRow[columnNo] = rowMeta.getBigNumber(row, columnNo);
                            continue block13;
                        }
                        case 4: {
                            dataRow[columnNo] = rowMeta.getBoolean(row, columnNo);
                            continue block13;
                        }
                        case 3: {
                            dataRow[columnNo] = rowMeta.getDate(row, columnNo);
                            continue block13;
                        }
                        case 5: {
                            dataRow[columnNo] = rowMeta.getInteger(row, columnNo);
                            continue block13;
                        }
                        case 0: {
                            dataRow[columnNo] = rowMeta.getString(row, columnNo);
                            continue block13;
                        }
                        case 1: {
                            dataRow[columnNo] = rowMeta.getNumber(row, columnNo);
                            continue block13;
                        }
                        case 2: {
                            dataRow[columnNo] = rowMeta.getString(row, columnNo);
                            continue block13;
                        }
                        case 8: {
                            dataRow[columnNo] = rowMeta.getBinary(row, columnNo);
                            continue block13;
                        }
                        default: {
                            dataRow[columnNo] = rowMeta.getString(row, columnNo);
                        }
                    }
                }
                this.tableModel.addRow(dataRow);
            }
            catch (KettleValueException kve) {
                throw new KettleStepException((Throwable)kve);
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }

        private TypedTableModel createTableModel(RowMetaInterface rowMeta) {
            int colCount = rowMeta.size();
            String[] fieldNames = new String[colCount];
            Class[] fieldTypes = new Class[colCount];
            block10: for (int columnNo = 0; columnNo < colCount; ++columnNo) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(columnNo);
                fieldNames[columnNo] = valueMeta.getName();
                switch (valueMeta.getType()) {
                    case 6: {
                        fieldTypes[columnNo] = BigDecimal.class;
                        continue block10;
                    }
                    case 4: {
                        fieldTypes[columnNo] = Boolean.class;
                        continue block10;
                    }
                    case 3: {
                        fieldTypes[columnNo] = Date.class;
                        continue block10;
                    }
                    case 5: {
                        fieldTypes[columnNo] = Integer.class;
                        continue block10;
                    }
                    case 0: {
                        fieldTypes[columnNo] = String.class;
                        continue block10;
                    }
                    case 1: {
                        fieldTypes[columnNo] = Double.class;
                        continue block10;
                    }
                    case 2: {
                        fieldTypes[columnNo] = String.class;
                        continue block10;
                    }
                    case 8: {
                        fieldTypes[columnNo] = byte[].class;
                        continue block10;
                    }
                    default: {
                        fieldTypes[columnNo] = String.class;
                    }
                }
            }
            return new TypedTableModel(fieldNames, fieldTypes);
        }

        public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        }

        public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            if (this.stopOnError) {
                throw new KettleStepException("Aborting transformation due to error detected");
            }
            this.error = true;
        }

        public TableModel getTableModel() throws ReportDataFactoryException {
            if (this.stopOnError && this.error) {
                throw new ReportDataFactoryException("Transformation produced an error.");
            }
            if (this.tableModel == null) {
                return this.createTableModel(this.rowMeta);
            }
            return this.tableModel;
        }
    }
}

