/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class KettleDataFactory
implements DataFactory,
Cloneable {
    private transient ResourceManager resourceManager;
    private transient ResourceKey contextKey;
    private HashMap<String, KettleTransformationProducer> queries = new HashMap();
    private transient KettleTransformationProducer currentlyRunningQuery;

    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) {
        this.resourceManager = resourceManager;
        this.contextKey = contextKey;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ResourceKey getContextKey() {
        return this.contextKey;
    }

    public void setQuery(String name, KettleTransformationProducer value) {
        if (value == null) {
            this.queries.remove(name);
        } else {
            this.queries.put(name, value);
        }
    }

    public KettleTransformationProducer getQuery(String name) {
        return this.queries.get(name);
    }

    public String[] getQueryNames() {
        return this.queries.keySet().toArray(new String[this.queries.size()]);
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        int queryLimit;
        Object queryLimitRaw = parameters.get("::org.pentaho.reporting::query-limit");
        if (queryLimitRaw instanceof Number) {
            Number queryLimitNum = (Number)queryLimitRaw;
            queryLimit = queryLimitNum.intValue();
        } else {
            queryLimit = 0;
        }
        KettleTransformationProducer producer = this.queries.get(query);
        if (producer == null) {
            throw new ReportDataFactoryException("There is no such query defined: " + query);
        }
        try {
            this.currentlyRunningQuery = producer;
            TableModel tableModel = producer.performQuery(parameters, queryLimit, this.resourceManager, this.contextKey);
            return tableModel;
        }
        catch (ReportDataFactoryException rdfe) {
            throw rdfe;
        }
        catch (Throwable e) {
            throw new ReportDataFactoryException("Caught Kettle Exception: Check your configuration", e);
        }
        finally {
            this.currentlyRunningQuery = null;
        }
    }

    public DataFactory derive() {
        return (KettleDataFactory)this.clone();
    }

    public Object clone() {
        try {
            KettleDataFactory df = (KettleDataFactory)super.clone();
            df.queries = (HashMap)this.queries.clone();
            df.currentlyRunningQuery = null;
            for (Map.Entry<String, KettleTransformationProducer> entry : df.queries.entrySet()) {
                KettleTransformationProducer value = entry.getValue();
                entry.setValue((KettleTransformationProducer)value.clone());
            }
            return df;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failed to derive the Kettle-DataFactory", e);
        }
    }

    public void open() throws ReportDataFactoryException {
    }

    public void close() {
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.queries.containsKey(query);
    }

    public void cancelRunningQuery() {
        KettleTransformationProducer producer = this.currentlyRunningQuery;
        if (producer != null) {
            producer.cancelQuery();
            this.currentlyRunningQuery = null;
        }
    }

    public Object getQueryHash(String queryName) {
        KettleTransformationProducer transformationProducer = this.getQuery(queryName);
        if (transformationProducer == null) {
            return null;
        }
        return transformationProducer.getQueryHash(this.resourceManager, this.contextKey);
    }
}

