/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.DataFactoryWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransFromFileProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransFromRepositoryProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class KettleDataFactoryWriteHandler
implements DataFactoryWriteHandler {
    public void write(ReportWriterContext reportWriter, XmlWriter xmlWriter, DataFactory dataFactory) throws IOException, ReportWriterException {
        KettleDataFactory kettleDataFactory = (KettleDataFactory)dataFactory;
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/kettle");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "kettle-datasource", rootAttrs, false);
        String[] queryNames = kettleDataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            KettleTransformationProducer prod = kettleDataFactory.getQuery(queryName);
            if (prod instanceof KettleTransFromFileProducer) {
                this.writeKettleFileProducer(xmlWriter, queryName, (KettleTransFromFileProducer)prod);
                continue;
            }
            if (prod instanceof KettleTransFromRepositoryProducer) {
                this.writeKettleRepositoryProducer(xmlWriter, queryName, (KettleTransFromRepositoryProducer)prod);
                continue;
            }
            throw new ReportWriterException("Failed to write Kettle-Producer: Unknown implementation.");
        }
        xmlWriter.writeCloseTag();
    }

    private void writeKettleFileProducer(XmlWriter xmlWriter, String queryName, KettleTransFromFileProducer fileProducer) throws IOException {
        int i;
        AttributeList coreAttrs = new AttributeList();
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "name", queryName);
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "repository", fileProducer.getRepositoryName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "filename", fileProducer.getTransformationFile());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "step", fileProducer.getStepName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "username", fileProducer.getUsername());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "password", fileProducer.getPassword());
        String[] definedArgumentNames = fileProducer.getDefinedArgumentNames();
        ParameterMapping[] parameterMappings = fileProducer.getDefinedVariableNames();
        if (definedArgumentNames.length == 0 && parameterMappings.length == 0) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-file", coreAttrs, true);
            return;
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-file", coreAttrs, false);
        for (i = 0; i < definedArgumentNames.length; ++i) {
            String argumentName = definedArgumentNames[i];
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "argument", "datarow-name", argumentName, true);
        }
        for (i = 0; i < parameterMappings.length; ++i) {
            ParameterMapping parameterMapping = parameterMappings[i];
            AttributeList paramAttr = new AttributeList();
            paramAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "datarow-name", parameterMapping.getName());
            if (!parameterMapping.getName().equals(parameterMapping.getAlias())) {
                paramAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "variable-name", parameterMapping.getAlias());
            }
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "variable", paramAttr, true);
        }
        xmlWriter.writeCloseTag();
    }

    private void writeKettleRepositoryProducer(XmlWriter xmlWriter, String queryName, KettleTransFromRepositoryProducer repositoryProducer) throws IOException {
        int i;
        AttributeList coreAttrs = new AttributeList();
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "name", queryName);
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "repository", repositoryProducer.getRepositoryName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "directory", repositoryProducer.getDirectoryName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "transformation", repositoryProducer.getTransformationName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "step", repositoryProducer.getStepName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "username", repositoryProducer.getUsername());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "password", repositoryProducer.getPassword());
        String[] definedArgumentNames = repositoryProducer.getDefinedArgumentNames();
        ParameterMapping[] parameterMappings = repositoryProducer.getDefinedVariableNames();
        if (definedArgumentNames.length == 0 && parameterMappings.length == 0) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-repository", coreAttrs, true);
            return;
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-repository", coreAttrs, false);
        for (i = 0; i < definedArgumentNames.length; ++i) {
            String argumentName = definedArgumentNames[i];
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "argument", "datarow-name", argumentName, true);
        }
        for (i = 0; i < parameterMappings.length; ++i) {
            ParameterMapping parameterMapping = parameterMappings[i];
            AttributeList paramAttr = new AttributeList();
            paramAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "datarow-name", parameterMapping.getName());
            if (!parameterMapping.getName().equals(parameterMapping.getAlias())) {
                paramAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "variable-name", parameterMapping.getAlias());
            }
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "variable", paramAttr, true);
        }
        xmlWriter.writeCloseTag();
    }
}

