/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.io.PrintStream;

public class TreeMetrics {
    private int depth;
    private int numOfPages;
    private long totalBytes;
    private long usedBytes;
    private long numOfEntries;
    private long numOfLeafEntries;

    public TreeMetrics(int depth, int numOfPages, long totalBytes, long usedBytes, long numOfEntries, long numberOfLeafEntries) {
        this.depth = depth;
        this.numOfPages = numOfPages;
        this.totalBytes = totalBytes;
        this.usedBytes = usedBytes;
        this.numOfEntries = numOfEntries;
        this.numOfLeafEntries = numberOfLeafEntries;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getNumberOfPages() {
        return this.numOfPages;
    }

    public double getLoadFactor() {
        return this.totalBytes > 0L ? (double)this.usedBytes / (double)this.totalBytes : 0.0;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setNumberOfPages(int numOfPages) {
        this.numOfPages = numOfPages;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public void setUsedBytes(long usedBytes) {
        this.usedBytes = usedBytes;
    }

    public void print(PrintStream stream) {
        stream.println("depth: " + this.depth);
        stream.println("#pages: " + this.numOfPages);
        stream.println("#entries: " + this.numOfEntries);
        stream.println("#leaf entries: " + this.numOfLeafEntries);
        stream.println("used bytes: " + this.usedBytes);
        stream.println("total bytes: " + this.totalBytes);
        stream.println("load factor: " + this.getLoadFactor());
    }

    public static TreeMetrics computeParent(TreeMetrics[] m, long tBytes, long uBytes, long entries) {
        int d = 0;
        int pages = 0;
        long bytes = 0L;
        long used = 0L;
        long entrs = 0L;
        long leafEntries = 0L;
        int x = 0;
        while (x < m.length) {
            if (m[x].getDepth() > d) {
                d = m[x].getDepth();
            }
            pages += m[x].getNumberOfPages();
            bytes += m[x].getTotalBytes();
            used += m[x].getUsedBytes();
            entrs += m[x].getNumOfEntries();
            leafEntries += m[x].getNumOfLeafEntries();
            ++x;
        }
        return new TreeMetrics(d + 1, pages + 1, bytes + tBytes, used + uBytes, entrs + entries, leafEntries);
    }

    public long getNumOfEntries() {
        return this.numOfEntries;
    }

    public void setNumOfEntries(long numOfEntries) {
        this.numOfEntries = numOfEntries;
    }

    public long getNumOfLeafEntries() {
        return this.numOfLeafEntries;
    }

    public void setNumOfLeafEntries(long numOfLeafEntries) {
        this.numOfLeafEntries = numOfLeafEntries;
    }
}

