/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.sample.wordcount;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.pentaho.hadoop.sample.wordcount.WordCountMapper;
import org.pentaho.hadoop.sample.wordcount.WordCountReducer;

public class WordCount {
    public static void main(String[] jobConf) throws Exception {
        String string = "localhost:9000";
        String string2 = "localhost:9001";
        String string3 = "/wordcount/input";
        String string4 = "/wordcount/output";
        if (((String[])jobConf).length == 1 && (jobConf[0].equals("--help") || jobConf[0].equals("-h") || jobConf[0].equals("/?"))) {
            System.out.println("Usage: WordCount <options>");
            System.out.println();
            System.out.println("Options:");
            System.out.println();
            System.out.println("--input=DIR                   The directory containing the input files for the");
            System.out.println("                              WordCount Hadoop job");
            System.out.println("--output=DIR                  The directory where the results of the WordCount");
            System.out.println("                              Hadoop job will be stored");
            System.out.println("--hdfsHost=HOST               The host<:port> of the HDFS service");
            System.out.println("                              e.g.- localhost:9000");
            System.out.println("--jobTrackerHost=HOST         The host<:port> of the job tracker service");
            System.out.println("                              e.g.- localhost:9001");
            System.out.println();
            System.out.println();
            System.out.println("If an option is not provided through the command prompt the following defaults");
            System.out.println("will be used:");
            System.out.println("--input='/wordcount/input'");
            System.out.println("--output='/wordcount/output'");
            System.out.println("--hdfsHost=localhost:9000");
            System.out.println("--jobTrackerHost=localhost:9001");
        } else {
            if (((String[])jobConf).length > 0) {
                for (JobConf jobConf2 : jobConf) {
                    if (jobConf2.startsWith("--input=")) {
                        string3 = WordCount.getArgValue((String)jobConf2);
                        continue;
                    }
                    if (jobConf2.startsWith("--output=")) {
                        string4 = WordCount.getArgValue((String)jobConf2);
                        continue;
                    }
                    if (jobConf2.startsWith("--hdfsHost=")) {
                        string = WordCount.getArgValue((String)jobConf2);
                        continue;
                    }
                    if (!jobConf2.startsWith("--jobTrackerHost=")) continue;
                    string2 = WordCount.getArgValue((String)jobConf2);
                }
            }
            JobConf jobConf3 = new JobConf(WordCount.class);
            jobConf3.setJobName("WordCount");
            String string5 = "hdfs://" + string;
            jobConf3.set("fs.default.name", string5);
            jobConf3.set("mapred.job.tracker", string2);
            FileInputFormat.setInputPaths((JobConf)jobConf3, (Path[])new Path[]{new Path(string5 + string3)});
            FileOutputFormat.setOutputPath((JobConf)jobConf3, (Path)new Path(string5 + string4));
            jobConf3.setMapperClass(WordCountMapper.class);
            jobConf3.setReducerClass(WordCountReducer.class);
            jobConf3.setMapOutputKeyClass(Text.class);
            jobConf3.setMapOutputValueClass(IntWritable.class);
            jobConf3.setOutputKeyClass(Text.class);
            jobConf3.setOutputValueClass(IntWritable.class);
            JobClient.runJob((JobConf)jobConf3);
        }
    }

    private static String getArgValue(String string) {
        String string2 = null;
        String[] stringArray = string.split("=");
        if (stringArray.length > 1) {
            string2 = stringArray[1].replace("'", "").replace("\"", "");
        }
        return string2;
    }
}

