/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class BarcodeTypePropertyEditor
implements PropertyEditor {
    private String value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void setValue(Object value) {
        String oldValue = this.value;
        this.value = this.isValidBarcode(value) ? (String)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    private boolean isValidBarcode(Object barodeType) {
        if ("2of5".equals(barodeType)) {
            return true;
        }
        if ("2of5int".equals(barodeType)) {
            return true;
        }
        if ("codabar".equals(barodeType)) {
            return true;
        }
        if ("code128".equals(barodeType)) {
            return true;
        }
        if ("code128a".equals(barodeType)) {
            return true;
        }
        if ("code128b".equals(barodeType)) {
            return true;
        }
        if ("code128c".equals(barodeType)) {
            return true;
        }
        if ("code128a".equals(barodeType)) {
            return true;
        }
        if ("code39".equals(barodeType)) {
            return true;
        }
        if ("code39ext".equals(barodeType)) {
            return true;
        }
        if ("ean13".equals(barodeType)) {
            return true;
        }
        if ("isbn".equals(barodeType)) {
            return true;
        }
        if ("pdf417".equals(barodeType)) {
            return true;
        }
        if ("pdf417".equals(barodeType)) {
            return true;
        }
        if ("postnet".equals(barodeType)) {
            return true;
        }
        if ("uccean128".equals(barodeType)) {
            return true;
        }
        return "upca".equals(barodeType);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return this.value;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public String[] getTags() {
        return new String[]{"2of5", "2of5int", "codabar", "code128", "code128a", "code128b", "code128c", "code39", "code39ext", "ean13", "isbn", "pdf417", "postnet", "uccean128", "upca"};
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

