/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.output.OutputException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.layout.LayoutSupport;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class BarcodeWrapper
implements ReportDrawable {
    private static final Log logger = LogFactory.getLog(BarcodeWrapper.class);
    private static final Color ALPHA = new Color(255, 255, 255, 0);
    private Barcode barcode;
    private Dimension preferredSize;

    public BarcodeWrapper(Barcode barcode) {
        if (barcode == null) {
            throw new IllegalArgumentException("Barcode to wrap must not be null");
        }
        this.barcode = barcode;
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = this.barcode.getSize();
        }
        return this.preferredSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D g2, Rectangle2D bounds) {
        Graphics2D gr2 = (Graphics2D)g2.create();
        try {
            gr2.clip(bounds);
            this.barcode.draw(gr2, (int)bounds.getX(), (int)bounds.getY());
        }
        catch (OutputException e) {
            logger.error((Object)"Unable to draw barcode element", (Throwable)e);
        }
        finally {
            gr2.dispose();
        }
    }

    public void setLayoutSupport(LayoutSupport layoutSupport) {
    }

    public void setConfiguration(Configuration config) {
    }

    public void setStyleSheet(StyleSheet style) {
        if (style != null) {
            String fontName = (String)style.getStyleProperty(TextStyleKeys.FONT);
            int fontSize = style.getIntStyleProperty(TextStyleKeys.FONTSIZE, 0);
            boolean bold = style.getBooleanStyleProperty(TextStyleKeys.BOLD);
            boolean italics = style.getBooleanStyleProperty(TextStyleKeys.ITALIC);
            Color foregroundColor = (Color)style.getStyleProperty(ElementStyleKeys.PAINT);
            Color backgroundColor = (Color)style.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
            if (fontName != null && fontSize > 0) {
                int fontstyle = 0;
                if (bold) {
                    fontstyle |= 1;
                }
                if (italics) {
                    fontstyle |= 2;
                }
                this.barcode.setFont(new Font(fontName, fontstyle, fontSize));
            }
            if (foregroundColor != null) {
                this.barcode.setForeground(foregroundColor);
            }
            if (backgroundColor != null) {
                this.barcode.setBackground(backgroundColor);
                this.barcode.setOpaque(backgroundColor.getAlpha() == 255);
            } else {
                this.barcode.setBackground(ALPHA);
                this.barcode.setOpaque(false);
            }
        }
    }

    public void setResourceBundleFactory(ResourceBundleFactory bundleFactory) {
    }

    public ImageMap getImageMap(Rectangle2D bounds) {
        return null;
    }
}

