/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes;

import java.awt.Color;
import java.util.Locale;
import net.sourceforge.barbecue.Barcode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.types.ContentType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.BarcodeWrapper;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.SimpleBarcodesUtility;

public class SimpleBarcodesType
extends ContentType {
    private static final Log logger = LogFactory.getLog(SimpleBarcodesType.class);
    private static final Color ALPHA = new Color(255, 255, 255, 0);
    private transient ElementMetaData elementType;

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("simple-barcodes");
        }
        return this.elementType;
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        Object value = ElementTypeUtils.queryStaticValue((Element)element);
        if (value == null) {
            value = "Barcode";
        }
        return this.createBarcode(runtime, element, value);
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        Object value = ElementTypeUtils.queryFieldOrValue((ExpressionRuntime)runtime, (Element)element);
        if (value == null) {
            Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
            return this.filter(runtime, element, nullValue);
        }
        return this.createBarcode(runtime, element, value);
    }

    private Object createBarcode(ExpressionRuntime runtime, Element element, Object value) {
        String type = (String)element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", "type");
        if (type == null) {
            Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
            return this.filter(runtime, element, nullValue);
        }
        Color color = (Color)element.getStyle().getStyleProperty(ElementStyleKeys.PAINT, (Object)Color.BLACK);
        Color backgroundColor = (Color)element.getStyle().getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)ALPHA);
        int barHeight = ElementTypeUtils.getIntAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", (String)"bar-height", (int)10);
        int barWidth = ElementTypeUtils.getIntAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", (String)"bar-width", (int)1);
        boolean showText = ElementTypeUtils.getBooleanAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", (String)"show-text", (boolean)true);
        boolean checksum = ElementTypeUtils.getBooleanAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", (String)"checksum", (boolean)true);
        try {
            Barcode barcode = SimpleBarcodesUtility.createBarcode(value.toString(), type, checksum);
            if (barcode == null) {
                Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
                return this.filter(runtime, element, nullValue);
            }
            barcode.setBackground(backgroundColor);
            barcode.setForeground(color);
            barcode.setDrawingText(showText);
            barcode.setBarWidth(barWidth);
            barcode.setBarHeight(barHeight);
            barcode.setOpaque(backgroundColor.getAlpha() == 255);
            return new BarcodeWrapper(barcode);
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Error creating barcode, falling back to null value", (Throwable)e);
            }
            Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
            return this.filter(runtime, element, nullValue);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void configureDesignTimeDefaults(Element element, Locale locale) {
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", "type", (Object)"code128");
    }
}

