/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes;

import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.linear.codabar.CodabarBarcode;
import net.sourceforge.barbecue.linear.code128.Code128Barcode;
import net.sourceforge.barbecue.linear.code39.Code39Barcode;
import net.sourceforge.barbecue.linear.ean.BooklandBarcode;
import net.sourceforge.barbecue.linear.ean.EAN13Barcode;
import net.sourceforge.barbecue.linear.ean.UCCEAN128Barcode;
import net.sourceforge.barbecue.linear.postnet.PostNetBarcode;
import net.sourceforge.barbecue.linear.twoOfFive.Int2of5Barcode;
import net.sourceforge.barbecue.linear.twoOfFive.Std2of5Barcode;
import net.sourceforge.barbecue.linear.upc.UPCABarcode;
import net.sourceforge.barbecue.twod.pdf417.PDF417Barcode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.SimpleBarcodesExpression;

public class SimpleBarcodesUtility {
    public static final String BARCODE_CODE39 = "code39";
    public static final String BARCODE_CODE39EXT = "code39ext";
    public static final String BARCODE_CODABAR = "codabar";
    public static final String BARCODE_CODE128 = "code128";
    public static final String BARCODE_CODE128A = "code128a";
    public static final String BARCODE_CODE128B = "code128b";
    public static final String BARCODE_CODE128C = "code128c";
    public static final String BARCODE_EAN13 = "ean13";
    public static final String BARCODE_UPCA = "upca";
    public static final String BARCODE_ISBN = "isbn";
    public static final String BARCODE_UCCEAN128 = "uccean128";
    public static final String BARCODE_2OF5 = "2of5";
    public static final String BARCODE_2OF5INT = "2of5int";
    public static final String BARCODE_POSTNET = "postnet";
    public static final String BARCODE_PDF417 = "pdf417";
    private static final Log logger = LogFactory.getLog(SimpleBarcodesExpression.class);

    private SimpleBarcodesUtility() {
    }

    public static Barcode createBarcode(String data, String type, boolean checksum) {
        if (data == null || type == null) {
            throw new IllegalArgumentException("Barcode type or data must not be null");
        }
        if (BARCODE_CODE39.equals(type)) {
            try {
                return new Code39Barcode(data, checksum, false);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code39(ext) data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODE39EXT.equals(type)) {
            try {
                return new Code39Barcode(data, checksum, true);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code39(ext) data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODABAR.equals(type)) {
            try {
                return new CodabarBarcode(data);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong codabar data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_EAN13.equals(type)) {
            try {
                return new EAN13Barcode(data);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong ean13 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_UPCA.equals(type)) {
            try {
                return new UPCABarcode(data, false);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong upca data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_ISBN.equals(type)) {
            try {
                return new BooklandBarcode(data);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong isbn data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODE128.equals(type)) {
            try {
                return new Code128Barcode(data, 3);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code128 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODE128A.equals(type)) {
            try {
                return new Code128Barcode(data, 0);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code128 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODE128B.equals(type)) {
            try {
                return new Code128Barcode(data, 1);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code128 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODE128C.equals(type)) {
            try {
                return new Code128Barcode(data, 2);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code128 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_UCCEAN128.equals(type)) {
            try {
                return new UCCEAN128Barcode(data, checksum);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong uccean128 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_2OF5.equals(type)) {
            try {
                return new Std2of5Barcode(data, checksum);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong std2of5 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_2OF5INT.equals(type)) {
            try {
                return new Int2of5Barcode(data, checksum);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong int2of5 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_POSTNET.equals(type)) {
            try {
                if (checksum) {
                    logger.info((Object)("Checkum property is not usable on barcode " + type));
                }
                return new PostNetBarcode(data);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong postnet data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_PDF417.equals(type)) {
            try {
                if (checksum) {
                    logger.info((Object)("Checkum property is not usable on barcode " + type));
                }
                return new PDF417Barcode(data);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong postnet data supplied", (Throwable)e);
                return null;
            }
        }
        logger.warn((Object)("Unknown barcode type '" + type + "'."));
        return null;
    }
}

