/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sparklines;

import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.types.ContentType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.extensions.modules.sparklines.PieSparklinesWrapper;
import org.pentaho.reporting.libraries.libsparklines.PieGraphDrawable;

public class PieSparklineType
extends ContentType {
    private transient ElementMetaData elementType;

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("pie-sparkline");
        }
        return this.elementType;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        Object retval = ElementTypeUtils.queryFieldOrValue((ExpressionRuntime)runtime, (Element)element);
        Number numbers = (Number)retval;
        if (numbers == null) {
            Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
            return this.filter(runtime, element, nullValue);
        }
        int startAngle = ElementTypeUtils.getIntAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", (String)"start-angle", (int)0);
        Number lowSlice = ElementTypeUtils.getNumberAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", (String)"low-slice", (Number)new Double(0.3));
        Number mediumSlice = ElementTypeUtils.getNumberAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", (String)"medium-slice", (Number)new Double(0.7));
        Number highSlice = ElementTypeUtils.getNumberAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", (String)"high-slice", (Number)new Double(1.0));
        boolean clockwise = ElementTypeUtils.getBooleanAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", (String)"counter-clockwise", (boolean)false);
        PieGraphDrawable drawable = new PieGraphDrawable();
        drawable.setValue(numbers);
        drawable.setStartAngle(startAngle);
        drawable.setLowSlice(lowSlice);
        drawable.setMediumSlice(mediumSlice);
        drawable.setHighSlice(highSlice);
        drawable.setCounterClockWise(clockwise);
        return new PieSparklinesWrapper(drawable);
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        Object retval = ElementTypeUtils.queryStaticValue((Element)element);
        if (!(retval instanceof Number)) {
            retval = new Double(0.75);
        }
        Number numbers = (Number)retval;
        int startAngle = ElementTypeUtils.getIntAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", (String)"start-angle", (int)0);
        Number lowSlice = ElementTypeUtils.getNumberAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", (String)"low-slice", (Number)new Double(0.3));
        Number mediumSlice = ElementTypeUtils.getNumberAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", (String)"medium-slice", (Number)new Double(0.7));
        Number highSlice = ElementTypeUtils.getNumberAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", (String)"high-slice", (Number)new Double(1.0));
        boolean clockwise = ElementTypeUtils.getBooleanAttribute((Element)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", (String)"counter-clockwise", (boolean)false);
        PieGraphDrawable drawable = new PieGraphDrawable();
        drawable.setValue(numbers);
        drawable.setStartAngle(startAngle);
        drawable.setLowSlice(lowSlice);
        drawable.setMediumSlice(mediumSlice);
        drawable.setHighSlice(highSlice);
        drawable.setCounterClockWise(clockwise);
        return new PieSparklinesWrapper(drawable);
    }

    public void configureDesignTimeDefaults(Element element, Locale locale) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

