/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sparklines.xml;

import java.awt.Color;
import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.StyleWriterUtility;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.elements.AbstractElementWriteHandler;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.beans.ColorValueConverter;
import org.pentaho.reporting.engine.classic.extensions.modules.sparklines.SparklineStyleKeys;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public abstract class AbstractSparklineWriteHandler
extends AbstractElementWriteHandler {
    private static final ColorValueConverter colorValueConverter = new ColorValueConverter();

    protected AbstractSparklineWriteHandler() {
    }

    protected void writeStyleInformation(XmlWriter writer, ElementStyleSheet style) throws IOException {
        String parentList = StyleWriterUtility.computeParentStyleList((ElementStyleSheet)style);
        if (parentList == null && style.getDefinedPropertyNamesArray().length == 0) {
            return;
        }
        AttributeList attList = new AttributeList();
        if (parentList != null) {
            attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "parent", parentList);
        }
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "element-style", attList, false);
        StyleWriterUtility.writeBandStyles((XmlWriter)writer, (ElementStyleSheet)style);
        StyleWriterUtility.writePageBandStyles((XmlWriter)writer, (ElementStyleSheet)style);
        StyleWriterUtility.writeCommonStyles((XmlWriter)writer, (ElementStyleSheet)style);
        StyleWriterUtility.writeContentStyles((XmlWriter)writer, (ElementStyleSheet)style);
        StyleWriterUtility.writeTextStyles((XmlWriter)writer, (ElementStyleSheet)style);
        StyleWriterUtility.writeSpatialStyles((XmlWriter)writer, (ElementStyleSheet)style);
        StyleWriterUtility.writeBorderStyles((XmlWriter)writer, (ElementStyleSheet)style);
        this.writeSparklineStyles(writer, style);
        writer.writeCloseTag();
    }

    protected void writeSparklineStyles(XmlWriter writer, ElementStyleSheet style) throws IOException {
        Color value;
        AttributeList bandStyleAtts = new AttributeList();
        if (style.isLocalKey(SparklineStyleKeys.HIGH_COLOR)) {
            value = (Color)style.getStyleProperty(SparklineStyleKeys.HIGH_COLOR);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", "high-color", ColorValueConverter.colorToString((Color)value));
        }
        if (style.isLocalKey(SparklineStyleKeys.MEDIUM_COLOR)) {
            value = (Color)style.getStyleProperty(SparklineStyleKeys.MEDIUM_COLOR);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", "medium-color", ColorValueConverter.colorToString((Color)value));
        }
        if (style.isLocalKey(SparklineStyleKeys.LOW_COLOR)) {
            value = (Color)style.getStyleProperty(SparklineStyleKeys.LOW_COLOR);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", "low-color", ColorValueConverter.colorToString((Color)value));
        }
        if (style.isLocalKey(SparklineStyleKeys.LAST_COLOR)) {
            value = (Color)style.getStyleProperty(SparklineStyleKeys.LAST_COLOR);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", "last-color", ColorValueConverter.colorToString((Color)value));
        }
        if (!bandStyleAtts.isEmpty()) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sparkline/1.0", "spark-styles", bandStyleAtts, true);
        }
    }
}

