/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.drools.ProviderInitializationException;
import org.drools.io.Resource;
import org.drools.io.ResourceChangeNotifier;
import org.drools.io.ResourceChangeScanner;
import org.drools.io.ResourceProvider;

public class ResourceFactory {
    private static ResourceProvider resourceProvider;

    public static ResourceChangeNotifier getResourceChangeNotifierService() {
        return ResourceFactory.getResourceProvider().getResourceChangeNotifierService();
    }

    public static ResourceChangeScanner getResourceChangeScannerService() {
        return ResourceFactory.getResourceProvider().getResourceChangeScannerService();
    }

    public static Resource newUrlResource(URL url) {
        return ResourceFactory.getResourceProvider().newUrlResource(url);
    }

    public static Resource newUrlResource(String path) {
        return ResourceFactory.getResourceProvider().newUrlResource(path);
    }

    public static Resource newFileResource(File file) {
        return ResourceFactory.getResourceProvider().newFileSystemResource(file);
    }

    public static Resource newFileResource(String fileName) {
        return ResourceFactory.getResourceProvider().newFileSystemResource(fileName);
    }

    public static Resource newByteArrayResource(byte[] bytes) {
        return ResourceFactory.getResourceProvider().newByteArrayResource(bytes);
    }

    public static Resource newInputStreamResource(InputStream stream) {
        return ResourceFactory.getResourceProvider().newInputStreamResource(stream);
    }

    public static Resource newReaderResource(Reader reader) {
        return ResourceFactory.getResourceProvider().newReaderResource(reader);
    }

    public static Resource newReaderResource(Reader reader, String encoding) {
        return ResourceFactory.getResourceProvider().newReaderResource(reader, encoding);
    }

    public static Resource newClassPathResource(String path) {
        return ResourceFactory.getResourceProvider().newClassPathResource(path);
    }

    public static Resource newClassPathResource(String path, Class clazz) {
        return ResourceFactory.getResourceProvider().newClassPathResource(path, clazz);
    }

    public static Resource newClassPathResource(String path, ClassLoader classLoader) {
        return ResourceFactory.getResourceProvider().newClassPathResource(path, classLoader);
    }

    private static synchronized void setResourceProvider(ResourceProvider provider) {
        resourceProvider = provider;
    }

    private static synchronized ResourceProvider getResourceProvider() {
        if (resourceProvider == null) {
            ResourceFactory.loadProvider();
        }
        return resourceProvider;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.io.impl.ResourceProviderImpl");
            ResourceFactory.setResourceProvider((ResourceProvider)cls.newInstance());
        }
        catch (Exception e2) {
            throw new ProviderInitializationException("Provider org.drools.io.impl.ResourceProviderImpl could not be set.", e2);
        }
    }
}

