/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.libraries.designtime.swing.Messages;

public class BasicFontPropertiesPane
extends JPanel {
    private JTextField fontFamilyTextBox;
    private JTextField fontSizeTextBox;
    private JList fontFamilyList;
    private JList fontSizeList;
    private JList fontStyleList;
    private EventListenerList eventListenerList = new EventListenerList();
    private JCheckBox underlineCheckbox;
    private JCheckBox strikethroughCheckbox;
    private boolean extendedFontPropertiesShowing;

    public BasicFontPropertiesPane() {
        FontNameUpdateHandler nameUpdateHandler = new FontNameUpdateHandler();
        this.fontFamilyTextBox = new JTextField();
        this.fontFamilyTextBox.getDocument().addDocumentListener(nameUpdateHandler);
        this.fontFamilyList = new JList(this.createFontNameModel());
        this.fontFamilyList.addListSelectionListener(nameUpdateHandler);
        FontSizeUpdateHandler sizeUpdateHandler = new FontSizeUpdateHandler();
        this.fontSizeTextBox = new JTextField();
        this.fontSizeTextBox.getDocument().addDocumentListener(sizeUpdateHandler);
        this.fontSizeList = new JList(this.createFontSizeModel());
        this.fontSizeList.addListSelectionListener(sizeUpdateHandler);
        this.fontStyleList = new JList(this.createFontStyleModel());
        this.fontStyleList.getSelectionModel().addListSelectionListener(new FontStyleUpdateHandler());
        this.extendedFontPropertiesShowing = true;
        this.underlineCheckbox = new JCheckBox(Messages.getInstance().getString("BasicFontPropertiesPane.Underline"));
        this.underlineCheckbox.addChangeListener(new FontStyleUpdateHandler());
        this.strikethroughCheckbox = new JCheckBox(Messages.getInstance().getString("BasicFontPropertiesPane.Strikethrough"));
        this.strikethroughCheckbox.addChangeListener(new FontStyleUpdateHandler());
    }

    protected boolean isExtendedFontPropertiesShowing() {
        return this.extendedFontPropertiesShowing;
    }

    public void setExtendedFontPropertiesShowing(boolean extendedFontPropertiesShowing) {
        this.extendedFontPropertiesShowing = extendedFontPropertiesShowing;
        this.underlineCheckbox.setVisible(extendedFontPropertiesShowing);
        this.strikethroughCheckbox.setVisible(extendedFontPropertiesShowing);
    }

    public void init() {
        JComponent previewPane;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)new JLabel(Messages.getInstance().getString("BasicFontPropertiesPane.FontFamily")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)new JLabel(Messages.getInstance().getString("BasicFontPropertiesPane.FontStyle")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)new JLabel(Messages.getInstance().getString("BasicFontPropertiesPane.FontSize")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.fontFamilyTextBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.add((Component)new JScrollPane(this.fontFamilyList), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)new JScrollPane(this.fontStyleList), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.fontSizeTextBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.add((Component)new JScrollPane(this.fontSizeList), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.underlineCheckbox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.strikethroughCheckbox, gbc);
        Component aliasPane = this.createAliasPanel();
        if (aliasPane != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.add(aliasPane, gbc);
        }
        if ((previewPane = this.createPreviewPane()) != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 3;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)previewPane, gbc);
        }
    }

    public String getFontFamily() {
        return this.fontFamilyTextBox.getText();
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamilyTextBox.setText(fontFamily);
    }

    public int getFontSize() {
        try {
            return Integer.parseInt(this.fontSizeTextBox.getText());
        }
        catch (NumberFormatException nfe) {
            return 10;
        }
    }

    public void setFontSize(int fontSize) {
        this.fontSizeTextBox.setText(String.valueOf(fontSize));
    }

    public int getFontStyle() {
        int index = this.fontStyleList.getSelectedIndex();
        if (index < 0 || index > 3) {
            return 0;
        }
        return index;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            this.fontStyleList.setSelectedIndex(0);
        } else {
            this.fontStyleList.setSelectedIndex(fontStyle);
        }
    }

    public boolean isUnderlined() {
        return this.underlineCheckbox.isSelected();
    }

    public void setUnderlined(boolean underlined) {
        this.underlineCheckbox.setSelected(underlined);
    }

    public boolean isStrikeThrough() {
        return this.strikethroughCheckbox.isSelected();
    }

    public void setStrikeThrough(boolean strikeThrough) {
        this.strikethroughCheckbox.setSelected(strikeThrough);
    }

    protected JComponent createPreviewPane() {
        return null;
    }

    protected Component createAliasPanel() {
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        this.eventListenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        this.eventListenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        ChangeListener[] changeListeners = (ChangeListener[])this.eventListenerList.getListeners(ChangeListener.class);
        for (int i = 0; i < changeListeners.length; ++i) {
            ChangeListener changeListener = changeListeners[i];
            changeListener.stateChanged(event);
        }
    }

    private DefaultListModel createFontStyleModel() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement(Messages.getInstance().getString("BasicFontPropertiesPane.FontStylePlain"));
        model.addElement(Messages.getInstance().getString("BasicFontPropertiesPane.FontStyleBold"));
        model.addElement(Messages.getInstance().getString("BasicFontPropertiesPane.FontStyleItalics"));
        model.addElement(Messages.getInstance().getString("BasicFontPropertiesPane.FontStyleBoldItalics"));
        return model;
    }

    private DefaultListModel createFontNameModel() {
        Object[] availableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(availableFontFamilyNames);
        DefaultListModel<Object> retval = new DefaultListModel<Object>();
        for (int i = 0; i < availableFontFamilyNames.length; ++i) {
            Object familyName = availableFontFamilyNames[i];
            retval.addElement(familyName);
        }
        return retval;
    }

    private DefaultListModel createFontSizeModel() {
        Integer[] fontSizes = new Integer[]{6, 8, 10, 12, 14, 16, 18, 20, 24, 28, 32, 36, 48, 72};
        DefaultListModel<Integer> retval = new DefaultListModel<Integer>();
        for (int i = 0; i < fontSizes.length; ++i) {
            Integer fontSize = fontSizes[i];
            retval.addElement(fontSize);
        }
        return retval;
    }

    private class FontStyleUpdateHandler
    implements ListSelectionListener,
    ChangeListener {
        private FontStyleUpdateHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            BasicFontPropertiesPane.this.fireChangeEvent();
        }

        public void stateChanged(ChangeEvent e) {
            BasicFontPropertiesPane.this.fireChangeEvent();
        }
    }

    private class FontNameUpdateHandler
    implements ListSelectionListener,
    DocumentListener {
        private boolean inUpdate;

        private FontNameUpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent e) {
            if (this.inUpdate) {
                return;
            }
            try {
                this.inUpdate = true;
                Object value = BasicFontPropertiesPane.this.fontFamilyList.getSelectedValue();
                if (value != null) {
                    BasicFontPropertiesPane.this.fontFamilyTextBox.setText((String)value);
                    BasicFontPropertiesPane.this.fireChangeEvent();
                }
            }
            finally {
                this.inUpdate = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFromTextField() {
            if (this.inUpdate) {
                return;
            }
            try {
                this.inUpdate = true;
                String value = BasicFontPropertiesPane.this.fontFamilyTextBox.getText();
                if (value != null && value.length() != 0) {
                    BasicFontPropertiesPane.this.fontFamilyList.setSelectedValue(value, true);
                }
                BasicFontPropertiesPane.this.fireChangeEvent();
            }
            finally {
                this.inUpdate = false;
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateFromTextField();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateFromTextField();
        }

        public void changedUpdate(DocumentEvent e) {
            this.updateFromTextField();
        }
    }

    private class FontSizeUpdateHandler
    implements ListSelectionListener,
    DocumentListener {
        private boolean inUpdate;

        private FontSizeUpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent e) {
            if (this.inUpdate) {
                return;
            }
            try {
                this.inUpdate = true;
                Object value = BasicFontPropertiesPane.this.fontSizeList.getSelectedValue();
                if (value != null) {
                    BasicFontPropertiesPane.this.fontSizeTextBox.setText(String.valueOf(value));
                }
                BasicFontPropertiesPane.this.fireChangeEvent();
            }
            finally {
                this.inUpdate = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFromTextField() {
            block6: {
                if (this.inUpdate) {
                    return;
                }
                try {
                    this.inUpdate = true;
                    String value = BasicFontPropertiesPane.this.fontSizeTextBox.getText();
                    if (value == null || value.length() == 0) break block6;
                    try {
                        BasicFontPropertiesPane.this.fontSizeList.setSelectedValue(new Integer(value), true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    BasicFontPropertiesPane.this.fireChangeEvent();
                }
                finally {
                    this.inUpdate = false;
                }
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateFromTextField();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateFromTextField();
        }

        public void changedUpdate(DocumentEvent e) {
            this.updateFromTextField();
        }
    }
}

