/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class ColorUtility {
    private static final HashMap knownColorNamesByColor = new HashMap();
    private static final HashMap knownColorsByName = new HashMap();

    public static String toAttributeValue(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Color)) {
            throw new ClassCastException("Is no instance of java.awt.Color");
        }
        Color c = (Color)o;
        String name = (String)knownColorNamesByColor.get(c);
        if (name != null) {
            return name;
        }
        String color = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        StringBuilder retval = new StringBuilder(7);
        retval.append('#');
        int fillUp = 6 - color.length();
        for (int i = 0; i < fillUp; ++i) {
            retval.append('0');
        }
        retval.append(color);
        return retval.toString();
    }

    public static Object toPropertyValue(String value) {
        if (value == null) {
            return null;
        }
        Object o = knownColorsByName.get(value.toLowerCase());
        if (o != null) {
            return o;
        }
        try {
            return Color.decode(value.trim());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("The color string '" + value + "' is not recognized.");
        }
    }

    public static Color[] getPredefinedExcelColors() {
        return new Color[]{new Color(0, 0, 0), new Color(255, 255, 255), new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(255, 255, 0), new Color(255, 0, 255), new Color(0, 255, 255), new Color(128, 0, 0), new Color(0, 128, 0), new Color(0, 0, 128), new Color(128, 128, 0), new Color(128, 0, 128), new Color(0, 128, 128), new Color(192, 192, 192), new Color(128, 128, 128), new Color(153, 153, 255), new Color(153, 51, 102), new Color(255, 255, 204), new Color(204, 255, 255), new Color(102, 0, 102), new Color(255, 128, 128), new Color(0, 102, 204), new Color(204, 204, 255), new Color(0, 0, 128), new Color(255, 0, 255), new Color(255, 255, 0), new Color(0, 255, 255), new Color(128, 0, 128), new Color(128, 0, 0), new Color(0, 128, 128), new Color(0, 0, 255), new Color(0, 204, 255), new Color(204, 255, 255), new Color(204, 255, 204), new Color(255, 255, 153), new Color(153, 204, 255), new Color(255, 153, 204), new Color(204, 153, 255), new Color(51, 102, 255), new Color(51, 204, 204), new Color(153, 204, 0), new Color(255, 204, 0), new Color(255, 153, 0), new Color(255, 102, 0), new Color(102, 102, 153), new Color(150, 150, 150), new Color(0, 51, 102), new Color(51, 153, 102), new Color(0, 51, 0), new Color(51, 51, 0), new Color(153, 51, 0), new Color(153, 51, 102), new Color(51, 51, 153), new Color(51, 51, 51)};
    }

    static {
        try {
            Field[] fields = Color.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !Modifier.isStatic(f.getModifiers())) continue;
                String name = f.getName();
                Object oColor = f.get(null);
                if (!(oColor instanceof Color)) continue;
                knownColorNamesByColor.put(oColor, name.toLowerCase());
                knownColorsByName.put(name.toLowerCase(), oColor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

