/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.pentaho.reporting.libraries.designtime.swing.Messages;

public abstract class CommonDialog
extends JDialog {
    private boolean confirmed;
    private Action confirmAction;
    private CancelAction cancelAction;

    protected CommonDialog() {
        this.setModal(true);
    }

    protected CommonDialog(Frame owner) throws HeadlessException {
        super(owner, true);
    }

    protected CommonDialog(Dialog owner) throws HeadlessException {
        super(owner, true);
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    protected void init() {
        this.confirmAction = new OKAction();
        this.cancelAction = new CancelAction();
        this.setDefaultCloseOperation(2);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(this.createContentPane(), "Center");
        contentPane.add((Component)this.createButtonsPane(), "South");
        this.setContentPane(contentPane);
        InputMap inputMap = contentPane.getInputMap(2);
        ActionMap actionMap = contentPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "confirm");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("confirm", this.getConfirmAction());
        actionMap.put("cancel", this.getCancelAction());
        this.pack();
    }

    protected Action getCancelAction() {
        return this.cancelAction;
    }

    protected abstract Component createContentPane();

    protected boolean performEdit() {
        this.confirmed = false;
        this.setModal(true);
        this.setVisible(true);
        return this.confirmed;
    }

    protected boolean hasCancelButton() {
        return true;
    }

    protected JPanel createButtonsPane() {
        JButton button = new JButton(this.getConfirmAction());
        button.setDefaultCapable(true);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2, 5, 5));
        buttonsPanel.add(button);
        if (this.hasCancelButton()) {
            buttonsPanel.add(new JButton(this.getCancelAction()));
        }
        JPanel buttonsCarrierPanel = new JPanel();
        buttonsCarrierPanel.setLayout(new FlowLayout(2));
        buttonsCarrierPanel.add(buttonsPanel);
        return buttonsCarrierPanel;
    }

    protected final Action getConfirmAction() {
        return this.confirmAction;
    }

    protected boolean validateInputs() {
        return true;
    }

    protected boolean validateInputs(boolean onConfirm) {
        return this.validateInputs();
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
            this.putValue("Name", Messages.getInstance().getString("CANCEL"));
        }

        public void actionPerformed(ActionEvent e) {
            CommonDialog.this.dispose();
        }
    }

    private class OKAction
    extends AbstractAction {
        private OKAction() {
            this.putValue("Name", Messages.getInstance().getString("OK"));
        }

        public void actionPerformed(ActionEvent e) {
            if (CommonDialog.this.validateInputs(true)) {
                CommonDialog.this.setConfirmed(true);
                CommonDialog.this.dispose();
            }
        }
    }
}

