/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Component;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class CommonFileChooser {
    private static final String LOCATION_PREFS = "org/pentaho/reporting/libraries/designtime/swing/CommonFileChooser/locations";
    private static final String STATIC_PREFS = "org/pentaho/reporting/libraries/designtime/swing/CommonFileChooser/staticprefs";
    private Preferences resourceLocationMappings = Preferences.userRoot().node("org/pentaho/reporting/libraries/designtime/swing/CommonFileChooser/locations");
    private JFileChooser fileChooser;
    private static CommonFileChooser commonFileChooser;
    private Preferences staticLocationMappings = Preferences.userRoot().node("org/pentaho/reporting/libraries/designtime/swing/CommonFileChooser/staticprefs");

    private CommonFileChooser() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setAcceptAllFileFilterUsed(true);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(0);
    }

    public int showDialog(Component parent, FileFilter[] filters, int mode, String key) {
        this.fileChooser.setSelectedFile(this.getCurrentLocation(key));
        this.fileChooser.updateUI();
        this.fileChooser.resetChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            this.fileChooser.addChoosableFileFilter(filters[i]);
        }
        int retval = mode == 0 ? this.fileChooser.showOpenDialog(parent) : this.fileChooser.showSaveDialog(parent);
        if (retval != 1) {
            this.resourceLocationMappings.put(key, this.fileChooser.getSelectedFile().getAbsolutePath());
        }
        return retval;
    }

    private File getCurrentLocation(String aKey) {
        String theLocationValue = this.resourceLocationMappings.get(aKey, null);
        if (theLocationValue != null) {
            return new File(theLocationValue);
        }
        String staticLocationValue = this.staticLocationMappings.get(aKey, null);
        if (staticLocationValue != null) {
            return new File(staticLocationValue);
        }
        return null;
    }

    public File getStaticLocation(String aKey) {
        String staticLocationValue = this.staticLocationMappings.get(aKey, null);
        if (this.staticLocationMappings != null) {
            return new File(staticLocationValue);
        }
        return null;
    }

    public void setStaticLocation(String aKey, File file) {
        this.staticLocationMappings.put(aKey, file.getAbsolutePath());
    }

    public File getSelectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    public void setSelectedFile(File file) {
        this.fileChooser.setSelectedFile(file);
    }

    public static synchronized CommonFileChooser getInstance() {
        if (commonFileChooser == null) {
            commonFileChooser = new CommonFileChooser();
        }
        return commonFileChooser;
    }
}

