/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class GenericCellEditor
extends DefaultCellEditor {
    private transient Constructor constructor;
    private transient Object value;
    private Class fallbackType;
    private boolean allowEmptyString;

    public GenericCellEditor(Class fallbackType) {
        this(fallbackType, false);
    }

    public GenericCellEditor(Class fallbackType, boolean allowEmptyString) {
        super(new JTextField());
        this.fallbackType = fallbackType;
        this.allowEmptyString = allowEmptyString;
        this.getComponent().setName("Table.editor");
    }

    public boolean stopCellEditing() {
        String s = (String)super.getCellEditorValue();
        if (!this.allowEmptyString && "".equals(s)) {
            return super.stopCellEditing();
        }
        if (this.constructor == null) {
            return super.stopCellEditing();
        }
        try {
            this.value = this.constructor.newInstance(s);
        }
        catch (Exception e) {
            JComponent editorComponent = (JComponent)this.getComponent();
            editorComponent.setBorder(new LineBorder(Color.red));
            return false;
        }
        return super.stopCellEditing();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        JComponent editorComponent = (JComponent)this.getComponent();
        editorComponent.setBorder(new LineBorder(Color.black));
        Class type = table.getColumnClass(column);
        if (type == Object.class) {
            type = this.fallbackType;
        }
        this.constructor = this.lookupConstructor(type);
        if (this.constructor == null) {
            this.constructor = this.lookupConstructor(this.fallbackType);
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    private Constructor lookupConstructor(Class type) {
        try {
            return type.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getCellEditorValue() {
        return this.value;
    }
}

