/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizontalLayout
implements LayoutManager {
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int BOTH = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    private int hgap;
    private int alignment;
    private int anchor;

    public HorizontalLayout() {
        this(5, 0, 1);
    }

    public HorizontalLayout(int hgap) {
        this(hgap, 0, 1);
    }

    public HorizontalLayout(int hgap, int alignment) {
        this(hgap, alignment, 1);
    }

    public HorizontalLayout(int hgap, int alignment, int anchor) {
        this.hgap = hgap;
        this.alignment = alignment;
        this.anchor = anchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container parent, boolean minimum) {
        Dimension dim = new Dimension(0, 0);
        Object object = parent.getTreeLock();
        synchronized (object) {
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = minimum ? c.getMinimumSize() : c.getPreferredSize();
                dim.height = Math.max(dim.height, d.height);
                dim.width += d.width;
                if (i <= 0) continue;
                dim.width += this.hgap;
            }
        }
        Insets insets = parent.getInsets();
        dim.width += insets.left + insets.right + this.hgap + this.hgap;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension d;
            Component c;
            int i;
            int n = parent.getComponentCount();
            Dimension pd = parent.getSize();
            int x = 0;
            for (i = 0; i < n; ++i) {
                c = parent.getComponent(i);
                d = c.getPreferredSize();
                x += d.width + this.hgap;
            }
            x -= this.hgap;
            x = this.alignment == 2 ? insets.left : (this.alignment == 0 ? (pd.width - x) / 2 : pd.width - x - insets.right);
            for (i = 0; i < n; ++i) {
                c = parent.getComponent(i);
                d = c.getPreferredSize();
                int y = insets.top;
                int height = d.height;
                if (this.anchor == 0) {
                    y = (pd.height - d.height) / 2;
                } else if (this.anchor == 2) {
                    y = pd.height - d.height - insets.bottom;
                } else if (this.anchor == 3) {
                    height = pd.height - insets.top - insets.bottom;
                }
                c.setBounds(x, y, d.width, height);
                x += d.width + this.hgap;
            }
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, true);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, false);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + " align=" + this.alignment + " anchor=" + this.anchor + ']';
    }
}

