/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class LibSwingUtil {
    private LibSwingUtil() {
    }

    public static void centerFrameOnScreen(Window frame) {
        LibSwingUtil.positionFrameOnScreen(frame, 0.5, 0.5);
    }

    public static void positionFrameOnScreen(Window frame, double horizontalPercent, double verticalPercent) {
        Rectangle s = frame.getGraphicsConfiguration().getBounds();
        Dimension f = frame.getSize();
        int spaceOnX = Math.max(s.width - f.width, 0);
        int spaceOnY = Math.max(s.height - f.height, 0);
        int x = (int)(horizontalPercent * (double)spaceOnX) + s.x;
        int y = (int)(verticalPercent * (double)spaceOnY) + s.y;
        frame.setBounds(x, y, f.width, f.height);
        frame.setBounds(s.intersection(frame.getBounds()));
    }

    public static void positionFrameRandomly(Window frame) {
        LibSwingUtil.positionFrameOnScreen(frame, Math.random(), Math.random());
    }

    public static void centerDialogInParent(Dialog dialog) {
        LibSwingUtil.positionDialogRelativeToParent(dialog, 0.5, 0.5);
    }

    public static void positionDialogRelativeToParent(Dialog dialog, double horizontalPercent, double verticalPercent) {
        Container parent = dialog.getParent();
        if (parent == null || !parent.isVisible()) {
            LibSwingUtil.positionFrameOnScreen(dialog, horizontalPercent, verticalPercent);
            return;
        }
        Dimension d = dialog.getSize();
        Dimension p = parent.getSize();
        int baseX = parent.getX();
        int baseY = parent.getY();
        int parentPointX = baseX + (int)(horizontalPercent * (double)p.width);
        int parentPointY = baseY + (int)(verticalPercent * (double)p.height);
        int dialogPointX = Math.max(0, parentPointX - (int)(horizontalPercent * (double)d.width));
        int dialogPointY = Math.max(0, parentPointY - (int)(verticalPercent * (double)d.height));
        Rectangle s = parent.getGraphicsConfiguration().getBounds();
        Rectangle r = new Rectangle(dialogPointX, dialogPointY, d.width, d.height);
        Rectangle intersectedDialogBounds = r.intersection(s);
        if (intersectedDialogBounds.width < d.width) {
            r.x = s.width - d.width;
            r.width = d.width;
        }
        if (intersectedDialogBounds.height < d.height) {
            r.y = s.height - d.height;
            r.height = d.height;
        }
        Rectangle finalIntersection = r.intersection(s);
        dialog.setBounds(finalIntersection);
    }

    public static Window getWindowAncestor(Component component) {
        while (!(component instanceof Window)) {
            if (component == null) {
                return null;
            }
            component = component.getParent();
        }
        return (Window)component;
    }

    public static boolean safeRestoreWindow(Window frame, Rectangle bounds) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            GraphicsDevice device = devices[i];
            Rectangle rectangle = device.getDefaultConfiguration().getBounds();
            if (!rectangle.contains(bounds) && !rectangle.equals(bounds)) continue;
            DebugLog.log((Object)("Found a usable screen-configuration: Restoring frame to " + bounds));
            frame.setBounds(bounds);
            frame.setVisible(true);
            return true;
        }
        return false;
    }
}

