/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.swing.Action;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.designtime.swing.ConsumableActionEvent;

public class MacOSXIntegration {
    private static final Log logger;
    public static final boolean MAC_OS_X;
    private static MacOSApplicationListener integration;
    private static Action preferencesAction;
    private static Action openFileAction;
    private static Action openApplicationAction;
    private static Action reOpenApplicationAction;
    private static Action printFileAction;
    private static Action aboutAction;
    private static Action quitAction;
    private static ArrayList queueOpenFiles;
    private static ArrayList queuePrintedFiles;
    private static boolean initialized;

    protected MacOSXIntegration() {
    }

    private static void init() {
        if (!MAC_OS_X) {
            return;
        }
        try {
            if (integration == null) {
                logger.warn((Object)"Installing MacOS integration support.");
                integration = new MacOSApplicationListener();
                queueOpenFiles = new ArrayList();
                queuePrintedFiles = new ArrayList();
            }
        }
        catch (Throwable t) {
            logger.warn((Object)"Unable to install the Mac-OS support.", t);
        }
    }

    public static Action getPreferencesAction() {
        return preferencesAction;
    }

    public static void setPreferencesAction(Action preferencesAction) {
        MacOSXIntegration.preferencesAction = preferencesAction;
        MacOSXIntegration.init();
    }

    public static Action getOpenFileAction() {
        return openFileAction;
    }

    public static void setOpenFileAction(Action openFileAction) {
        MacOSXIntegration.openFileAction = openFileAction;
        MacOSXIntegration.init();
        if (!queueOpenFiles.isEmpty()) {
            String[] fileNames = queueOpenFiles.toArray(new String[queueOpenFiles.size()]);
            for (int i = 0; i < fileNames.length; ++i) {
                String fileName = fileNames[i];
                logger.warn((Object)("Would like to work with File: " + fileName));
            }
            queueOpenFiles.clear();
        }
    }

    public static Action getOpenApplicationAction() {
        return openApplicationAction;
    }

    public static void setOpenApplicationAction(Action openApplicationAction) {
        MacOSXIntegration.openApplicationAction = openApplicationAction;
        MacOSXIntegration.init();
    }

    public static Action getReOpenApplicationAction() {
        return reOpenApplicationAction;
    }

    public static void setReOpenApplicationAction(Action reOpenApplicationAction) {
        MacOSXIntegration.reOpenApplicationAction = reOpenApplicationAction;
        MacOSXIntegration.init();
    }

    public static Action getPrintFileAction() {
        return printFileAction;
    }

    public static void setPrintFileAction(Action printFileAction) {
        MacOSXIntegration.printFileAction = printFileAction;
        MacOSXIntegration.init();
        if (!queuePrintedFiles.isEmpty()) {
            String[] fileNames = queuePrintedFiles.toArray(new String[queuePrintedFiles.size()]);
            for (int i = 0; i < fileNames.length; ++i) {
                String fileName = fileNames[i];
                logger.warn((Object)("Would like to print File: " + fileName));
            }
            queuePrintedFiles.clear();
        }
    }

    public static Action getAboutAction() {
        return aboutAction;
    }

    public static void setAboutAction(Action aboutAction) {
        MacOSXIntegration.aboutAction = aboutAction;
        MacOSXIntegration.init();
    }

    public static Action getQuitAction() {
        return quitAction;
    }

    public static void setQuitAction(Action quitAction) {
        MacOSXIntegration.quitAction = quitAction;
        MacOSXIntegration.init();
    }

    static {
        boolean result;
        logger = LogFactory.getLog(MacOSXIntegration.class);
        try {
            result = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        }
        catch (Exception e) {
            result = false;
        }
        MAC_OS_X = result;
    }

    private static class MacOSApplicationListener
    implements InvocationHandler {
        private Object application;

        private MacOSApplicationListener() throws Exception {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            Method getApplicationMethod = applicationClass.getDeclaredMethod("getApplication", new Class[0]);
            this.application = getApplicationMethod.invoke(null, new Object[0]);
            Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
            Method addListenerMethod = applicationClass.getDeclaredMethod("addApplicationListener", applicationListenerClass);
            Object osxAdapterProxy = Proxy.newProxyInstance(MacOSXIntegration.class.getClassLoader(), new Class[]{applicationListenerClass}, (InvocationHandler)this);
            addListenerMethod.invoke(this.application, osxAdapterProxy);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            System.out.println("Receiving event from Apple-System: " + method);
            if (this.isMatch("handleQuit", method, args)) {
                if (this.handleAction(args[0], quitAction, "handleQuit")) {
                    initialized = false;
                }
            } else if (this.isMatch("handleReOpenApplication", method, args)) {
                this.handleAction(args[0], reOpenApplicationAction, "handleReOpenApplication");
            } else if (this.isMatch("handleAbout", method, args)) {
                this.handleAction(args[0], aboutAction, "handleAbout");
            } else if (this.isMatch("handleOpenApplication", method, args)) {
                this.handleAction(args[0], openApplicationAction, "handleOpenApplication");
            } else if (this.isMatch("handleOpenFile", method, args)) {
                if (!this.handleAction(args[0], openFileAction, "handleOpenFile")) {
                    ApplicationEventSupport eventSupport = new ApplicationEventSupport(args);
                    if (!initialized && queueOpenFiles.size() < 100) {
                        queueOpenFiles.add(eventSupport.getFileName());
                    }
                }
            } else if (this.isMatch("handlePreferences", method, args)) {
                this.handleAction(args[0], preferencesAction, "handlePreferences");
            } else if (this.isMatch("handlePrintFile", method, args) && !this.handleAction(args[0], printFileAction, "handlePrintFile")) {
                ApplicationEventSupport eventSupport = new ApplicationEventSupport(args);
                if (!initialized && queuePrintedFiles.size() < 100) {
                    queuePrintedFiles.add(eventSupport.getFileName());
                }
            }
            return null;
        }

        private boolean handleAction(Object args, Action action, String method) {
            ApplicationEventSupport eventSupport = new ApplicationEventSupport(args);
            if (action == null) {
                eventSupport.setHandled(false);
                return false;
            }
            ConsumableActionEvent actionEvent = new ConsumableActionEvent(eventSupport, 0, method);
            action.actionPerformed(actionEvent);
            if (actionEvent.isConsumed()) {
                eventSupport.setHandled(true);
                return true;
            }
            eventSupport.setHandled(false);
            return false;
        }

        private boolean isMatch(String proxySignature, Method method, Object[] args) {
            return proxySignature.equals(method.getName()) && args.length == 1;
        }
    }

    public static class ApplicationEventSupport {
        private Object event;
        private boolean handled;

        public ApplicationEventSupport(Object event) {
            this.event = event;
        }

        public String getFileName() {
            if (this.event == null) {
                return null;
            }
            try {
                Method isHandledMethod = this.event.getClass().getDeclaredMethod("getFilename", new Class[0]);
                Object o = isHandledMethod.invoke(this.event, new Object[0]);
                if (o == null) {
                    return null;
                }
                return String.valueOf(o);
            }
            catch (Exception ex) {
                logger.debug((Object)("OSXAdapter was unable to handle an ApplicationEvent: " + this.event), (Throwable)ex);
                return null;
            }
        }

        public boolean isHandled() {
            if (this.event == null) {
                return this.handled;
            }
            try {
                Method isHandledMethod = this.event.getClass().getDeclaredMethod("isHandled", new Class[0]);
                Object o = isHandledMethod.invoke(this.event, new Object[0]);
                return Boolean.TRUE.equals(o);
            }
            catch (Exception ex) {
                logger.debug((Object)("OSXAdapter was unable to handle an ApplicationEvent: " + this.event), (Throwable)ex);
                return false;
            }
        }

        public void setHandled(boolean handled) {
            if (this.event == null) {
                this.handled = handled;
                return;
            }
            try {
                Method setHandledMethod = this.event.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                setHandledMethod.invoke(this.event, handled);
            }
            catch (Exception ex) {
                logger.debug((Object)("OSXAdapter was unable to handle an ApplicationEvent: " + this.event), (Throwable)ex);
            }
        }
    }
}

