/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class ToolbarButton
extends JButton {
    public ToolbarButton() {
        this.init();
    }

    public ToolbarButton(Icon icon) {
        super(icon);
        this.init();
    }

    public ToolbarButton(String text) {
        super(text);
        this.init();
    }

    public ToolbarButton(Action a) {
        super(a);
        this.init();
    }

    public ToolbarButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    protected void init() {
        this.addPropertyChangeListener("action", new ActionUpdateHandler());
        this.putClientProperty("JButton.buttonType", "square");
        this.putClientProperty("JComponent.sizeVariant", "small");
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.revalidateAction();
    }

    private void revalidateAction() {
        Action a = this.getAction();
        if (a == null) {
            this.putClientProperty("hideActionText", Boolean.FALSE);
        } else if (a.getValue("SmallIcon") != null || a.getValue("SwingLargeIconKey") != null) {
            this.putClientProperty("hideActionText", Boolean.TRUE);
        } else {
            this.putClientProperty("hideActionText", Boolean.FALSE);
        }
    }

    private class ActionUpdateHandler
    implements PropertyChangeListener {
        private ActionUpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolbarButton.this.revalidateAction();
        }
    }
}

