/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.background;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelListener;
import org.pentaho.reporting.libraries.designtime.swing.background.WaitDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.WaitDialogMonitorThread;

public class BackgroundCancellableProcessHelper {
    private BackgroundCancellableProcessHelper() {
    }

    public static void executeProcessWithCancelDialog(Thread workerThread, CancelListener cancelListener, Component parent) {
        BackgroundCancellableProcessHelper.executeProcessWithCancelDialog(workerThread, cancelListener, parent, null);
    }

    public static void executeProcessWithCancelDialog(Thread workerThread, CancelListener cancelListener, Component parent, String message) {
        WaitDialog waitDialog;
        if (workerThread == null) {
            throw new IllegalArgumentException();
        }
        workerThread.start();
        CreateWaitDialogTask dialogTask = new CreateWaitDialogTask(parent, cancelListener != null, message);
        if (SwingUtilities.isEventDispatchThread()) {
            dialogTask.run();
            waitDialog = dialogTask.getWaitDialog();
        } else {
            try {
                SwingUtilities.invokeAndWait(dialogTask);
            }
            catch (Exception e) {
                dialogTask.run();
            }
            waitDialog = dialogTask.getWaitDialog();
        }
        if (cancelListener != null) {
            waitDialog.addCancelListener(cancelListener);
        }
        if (workerThread.isAlive()) {
            WaitDialogMonitorThread monitorThread = new WaitDialogMonitorThread(workerThread, waitDialog);
            monitorThread.start();
            waitDialog.setVisible(true);
        }
    }

    protected static Window getWindowAncestor(Component component) {
        while (!(component instanceof Window)) {
            if (component == null) {
                return null;
            }
            component = component.getParent();
        }
        return (Window)component;
    }

    private static class CreateWaitDialogTask
    implements Runnable {
        private Component parent;
        private boolean allowCancel;
        private String message;
        private WaitDialog waitDialog;

        private CreateWaitDialogTask(Component parent, boolean allowCancel, String message) {
            this.parent = parent;
            this.allowCancel = allowCancel;
            this.message = message;
        }

        public WaitDialog getWaitDialog() {
            return this.waitDialog;
        }

        public void run() {
            Window w = BackgroundCancellableProcessHelper.getWindowAncestor(this.parent);
            this.waitDialog = w instanceof Frame ? new WaitDialog((Frame)w, this.allowCancel) : (w instanceof Dialog ? new WaitDialog((Dialog)w, this.allowCancel) : new WaitDialog(this.allowCancel));
            if (this.message != null) {
                this.waitDialog.setMessage(this.message);
            }
        }
    }
}

